<?php declare(strict_types=1);
/**
 * This file is automatic generated by build_docs.php file
 * and is used only for autocomplete in multiple IDE
 * don't modify manually.
 */

namespace danog\MadelineProto\Namespace;

interface Contacts
{
    /**
     * Get contact by telegram IDs.
     *
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @return list<int>
     */
    public function getContactIDs(array $hash = []): array;

    /**
     * Returns the list of contact statuses.
     *
     * @return list<array{_: 'contactStatus', status: array{_: 'userStatusEmpty'}|array{_: 'userStatusOnline', expires: int}|array{_: 'userStatusOffline', was_online: int}|array{_: 'userStatusRecently'}|array{_: 'userStatusLastWeek'}|array{_: 'userStatusLastMonth'}, user_id: int}> Array of  @see https://docs.madelineproto.xyz/API_docs/types/ContactStatus.html
     */
    public function getStatuses(): array;

    /**
     * Returns the current user's contact list.
     *
     * @param list<int>|array<never, never> $hash If there already is a full contact list on the client, a [hash](https://core.telegram.org/api/offsets#hash-generation) of a the list of contact IDs in ascending order may be passed in this parameter. If the contact set was not changed, [(contacts.contactsNotModified)](https://docs.madelineproto.xyz/API_docs/constructors/contacts.contactsNotModified.html) will be returned.
     * @return array{_: 'contacts.contactsNotModified'}|array{_: 'contacts.contacts', contacts: list<array{_: 'contact', mutual: bool, user_id: int}>, saved_count: int, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/contacts.Contacts.html
     */
    public function getContacts(array $hash = []): array;

    /**
     * Imports contacts: saves a full list on the server, adds already registered contacts to the contact list, returns added contacts and their info.
     *
     * Use [contacts.addContact](https://docs.madelineproto.xyz/API_docs/methods/contacts.addContact.html) to add Telegram contacts without actually using their phone number.
     *
     * @param list<array{_: 'inputPhoneContact', client_id?: int, phone?: string, first_name?: string, last_name?: string}>|array<never, never> $contacts Array of List of contacts to import @see https://docs.madelineproto.xyz/API_docs/types/InputContact.html
     * @return array{_: 'contacts.importedContacts', imported: list<array{_: 'importedContact', user_id: int, client_id: int}>, popular_invites: list<array{_: 'popularContact', client_id: int, importers: int}>, retry_contacts: list<int>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/contacts.ImportedContacts.html
     */
    public function importContacts(array $contacts = []): array;

    /**
     * Deletes several contacts from the list.
     *
     * @param list<array|int|string>|array<never, never> $id Array of User ID list @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function deleteContacts(array $id = []): array;

    /**
     * Delete contacts by phone number.
     *
     * @param list<string>|array<never, never> $phones Phone numbers
     */
    public function deleteByPhones(array $phones = []): bool;

    /**
     * Adds the user to the blacklist.
     *
     * @param array|int|string $id User ID @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     */
    public function block(array|int|string $id): bool;

    /**
     * Deletes the user from the blacklist.
     *
     * @param array|int|string $id User ID @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     */
    public function unblock(array|int|string $id): bool;

    /**
     * Returns the list of blocked users.
     *
     * @param int $offset The number of list elements to be skipped
     * @param int $limit The number of list elements to be returned
     * @return array{_: 'contacts.blocked', blocked: list<array{_: 'peerBlocked', peer_id: array|int|string, date: int}>, chats: list<array|int|string>, users: list<array|int|string>}|array{_: 'contacts.blockedSlice', count: int, blocked: list<array{_: 'peerBlocked', peer_id: array|int|string, date: int}>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/contacts.Blocked.html
     */
    public function getBlocked(int $offset = 0, int $limit = 0): array;

    /**
     * Returns users found by username substring.
     *
     * @param string $q Target substring
     * @param int $limit Maximum number of users to be returned
     * @return array{_: 'contacts.found', my_results: list<array|int|string>, results: list<array|int|string>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/contacts.Found.html
     */
    public function search(string $q = '', int $limit = 0): array;

    /**
     * Get most used peers.
     *
     * @param bool $correspondents Users we've chatted most frequently with
     * @param bool $bots_pm Most used bots
     * @param bool $bots_inline Most used inline bots
     * @param bool $phone_calls Most frequently called users
     * @param bool $forward_users Users to which the users often forwards messages to
     * @param bool $forward_chats Chats to which the users often forwards messages to
     * @param bool $groups Often-opened groups and supergroups
     * @param bool $channels Most frequently visited channels
     * @param int $offset Offset for [pagination](https://core.telegram.org/api/offsets)
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @param list<int>|array<never, never> $hash [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     * @return array{_: 'contacts.topPeersNotModified'}|array{_: 'contacts.topPeers', categories: list<array{_: 'topPeerCategoryPeers', category: array{_: 'topPeerCategoryBotsPM'}|array{_: 'topPeerCategoryBotsInline'}|array{_: 'topPeerCategoryCorrespondents'}|array{_: 'topPeerCategoryGroups'}|array{_: 'topPeerCategoryChannels'}|array{_: 'topPeerCategoryPhoneCalls'}|array{_: 'topPeerCategoryForwardUsers'}|array{_: 'topPeerCategoryForwardChats'}, count: int, peers: list<array{_: 'topPeer', peer: array|int|string, rating: float}>}>, chats: list<array|int|string>, users: list<array|int|string>}|array{_: 'contacts.topPeersDisabled'} @see https://docs.madelineproto.xyz/API_docs/types/contacts.TopPeers.html
     */
    public function getTopPeers(bool $correspondents = false, bool $bots_pm = false, bool $bots_inline = false, bool $phone_calls = false, bool $forward_users = false, bool $forward_chats = false, bool $groups = false, bool $channels = false, int $offset = 0, int $limit = 0, array $hash = []): array;

    /**
     * Reset [rating](https://core.telegram.org/api/top-rating) of top peer.
     *
     * @param array{_: 'topPeerCategoryBotsPM'}|array{_: 'topPeerCategoryBotsInline'}|array{_: 'topPeerCategoryCorrespondents'}|array{_: 'topPeerCategoryGroups'}|array{_: 'topPeerCategoryChannels'}|array{_: 'topPeerCategoryPhoneCalls'}|array{_: 'topPeerCategoryForwardUsers'}|array{_: 'topPeerCategoryForwardChats'} $category Top peer category @see https://docs.madelineproto.xyz/API_docs/types/TopPeerCategory.html
     * @param array|int|string $peer Peer whose rating should be reset @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     */
    public function resetTopPeerRating(array $category, array|int|string $peer): bool;

    /**
     * Delete saved contacts.
     *
     */
    public function resetSaved(): bool;

    /**
     * Get all contacts.
     *
     * @return list<array{_: 'savedPhoneContact', phone: string, first_name: string, last_name: string, date: int}> Array of  @see https://docs.madelineproto.xyz/API_docs/types/SavedContact.html
     */
    public function getSaved(): array;

    /**
     * Enable/disable [top peers](https://core.telegram.org/api/top-rating).
     *
     * @param bool $enabled Enable/disable
     */
    public function toggleTopPeers(bool $enabled): bool;

    /**
     * Add an existing telegram user as contact.
     *
     * Use [contacts.importContacts](https://docs.madelineproto.xyz/API_docs/methods/contacts.importContacts.html) to add contacts by phone number, without knowing their Telegram ID.
     *
     * @param array|int|string $id Telegram ID of the other user @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param bool $add_phone_privacy_exception Allow the other user to see our phone number?
     * @param string $first_name First name
     * @param string $last_name Last name
     * @param string $phone User's phone number
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function addContact(array|int|string $id, bool $add_phone_privacy_exception = false, string $first_name = '', string $last_name = '', string $phone = ''): array;

    /**
     * If the [peer settings](https://docs.madelineproto.xyz/API_docs/constructors/peerSettings.html) of a new user allow us to add them as contact, add that user as contact.
     *
     * @param array|int|string $id The user to add as contact @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function acceptContact(array|int|string $id): array;

    /**
     * Get contacts near you.
     *
     * @param array{_: 'inputGeoPointEmpty'}|array{_: 'inputGeoPoint', lat: float, long: float, accuracy_radius?: int} $geo_point Geolocation @see https://docs.madelineproto.xyz/API_docs/types/InputGeoPoint.html
     * @param bool $background While the geolocation of the current user is public, clients should update it in the background every half-an-hour or so, while setting this flag. <br>Do this only if the new location is more than 1 KM away from the previous one, or if the previous location is unknown.
     * @param int $self_expires If set, the geolocation of the current user will be public for the specified number of seconds; pass 0x7fffffff to disable expiry, 0 to make the current geolocation private; if the flag isn't set, no changes will be applied.
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function getLocated(array $geo_point, bool $background = false, int $self_expires = 0): array;

    /**
     * Stop getting notifications about [thread replies](https://core.telegram.org/api/threads) of a certain user in `@replies`.
     *
     * @param bool $delete_message Whether to delete the specified message as well
     * @param bool $delete_history Whether to delete all `@replies` messages from this user as well
     * @param bool $report_spam Whether to also report this user for spam
     * @param int $msg_id ID of the message in the [@replies](https://core.telegram.org/api/threads#replies) chat
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function blockFromReplies(bool $delete_message = false, bool $delete_history = false, bool $report_spam = false, int $msg_id = 0): array;

    /**
     * Resolve a phone number to get user info, if their privacy settings allow it.
     *
     * @param string $phone Phone number in international format, possibly obtained from a [phone number deep link](https://core.telegram.org/api/links#phone-number-links).
     * @return array{_: 'contacts.resolvedPeer', peer: array|int|string, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/contacts.ResolvedPeer.html
     */
    public function resolvePhone(string $phone = ''): array;

    /**
     *
     *
     * @return array{_: 'exportedContactToken', url: string, expires: int} @see https://docs.madelineproto.xyz/API_docs/types/ExportedContactToken.html
     */
    public function exportContactToken(): array;

    /**
     *
     *
     * @return array|int|string @see https://docs.madelineproto.xyz/API_docs/types/User.html
     */
    public function importContactToken(string $token = ''): array|int|string;
}
