<?php declare(strict_types=1);
/**
 * This file is automatically generated by the build_docs.php file
 * and is used only for autocompletion in multiple IDEs
 * don't modify it manually.
 */

namespace danog\MadelineProto;

use Amp\ByteStream\WritableStream;
use Amp\Cancellation;
use Amp\Future;
use Amp\Http\Server\Request as ServerRequest;
use Closure;
use Generator;

abstract class InternalDoc
{
    protected APIWrapper $wrapper;
    /** @var \danog\MadelineProto\Namespace\Auth $auth */
    public $auth;
    /** @var \danog\MadelineProto\Namespace\Account $account */
    public $account;
    /** @var \danog\MadelineProto\Namespace\Users $users */
    public $users;
    /** @var \danog\MadelineProto\Namespace\Contacts $contacts */
    public $contacts;
    /** @var \danog\MadelineProto\Namespace\Messages $messages */
    public $messages;
    /** @var \danog\MadelineProto\Namespace\Updates $updates */
    public $updates;
    /** @var \danog\MadelineProto\Namespace\Photos $photos */
    public $photos;
    /** @var \danog\MadelineProto\Namespace\Upload $upload */
    public $upload;
    /** @var \danog\MadelineProto\Namespace\Help $help */
    public $help;
    /** @var \danog\MadelineProto\Namespace\Channels $channels */
    public $channels;
    /** @var \danog\MadelineProto\Namespace\Bots $bots */
    public $bots;
    /** @var \danog\MadelineProto\Namespace\Payments $payments */
    public $payments;
    /** @var \danog\MadelineProto\Namespace\Stickers $stickers */
    public $stickers;
    /** @var \danog\MadelineProto\Namespace\Phone $phone */
    public $phone;
    /** @var \danog\MadelineProto\Namespace\Langpack $langpack */
    public $langpack;
    /** @var \danog\MadelineProto\Namespace\Folders $folders */
    public $folders;
    /** @var \danog\MadelineProto\Namespace\Stats $stats */
    public $stats;

    /**
     * Export APIFactory instance with the specified namespace.
     * @psalm-suppress InaccessibleProperty
     */
    protected function exportNamespaces(): void
    {
        $this->auth ??= new \danog\MadelineProto\Namespace\AbstractAPI('auth');
        $this->auth->setWrapper($this->wrapper);
        $this->account ??= new \danog\MadelineProto\Namespace\AbstractAPI('account');
        $this->account->setWrapper($this->wrapper);
        $this->users ??= new \danog\MadelineProto\Namespace\AbstractAPI('users');
        $this->users->setWrapper($this->wrapper);
        $this->contacts ??= new \danog\MadelineProto\Namespace\AbstractAPI('contacts');
        $this->contacts->setWrapper($this->wrapper);
        $this->messages ??= new \danog\MadelineProto\Namespace\AbstractAPI('messages');
        $this->messages->setWrapper($this->wrapper);
        $this->updates ??= new \danog\MadelineProto\Namespace\AbstractAPI('updates');
        $this->updates->setWrapper($this->wrapper);
        $this->photos ??= new \danog\MadelineProto\Namespace\AbstractAPI('photos');
        $this->photos->setWrapper($this->wrapper);
        $this->upload ??= new \danog\MadelineProto\Namespace\AbstractAPI('upload');
        $this->upload->setWrapper($this->wrapper);
        $this->help ??= new \danog\MadelineProto\Namespace\AbstractAPI('help');
        $this->help->setWrapper($this->wrapper);
        $this->channels ??= new \danog\MadelineProto\Namespace\AbstractAPI('channels');
        $this->channels->setWrapper($this->wrapper);
        $this->bots ??= new \danog\MadelineProto\Namespace\AbstractAPI('bots');
        $this->bots->setWrapper($this->wrapper);
        $this->payments ??= new \danog\MadelineProto\Namespace\AbstractAPI('payments');
        $this->payments->setWrapper($this->wrapper);
        $this->stickers ??= new \danog\MadelineProto\Namespace\AbstractAPI('stickers');
        $this->stickers->setWrapper($this->wrapper);
        $this->phone ??= new \danog\MadelineProto\Namespace\AbstractAPI('phone');
        $this->phone->setWrapper($this->wrapper);
        $this->langpack ??= new \danog\MadelineProto\Namespace\AbstractAPI('langpack');
        $this->langpack->setWrapper($this->wrapper);
        $this->folders ??= new \danog\MadelineProto\Namespace\AbstractAPI('folders');
        $this->folders->setWrapper($this->wrapper);
        $this->stats ??= new \danog\MadelineProto\Namespace\AbstractAPI('stats');
        $this->stats->setWrapper($this->wrapper);
    }
/**
         * Convert MTProto parameters to bot API parameters.
         *
         * @param array $data Data
         */
    public function MTProtoToBotAPI(array $data): array
    {
        return $this->wrapper->getAPI()->MTProtoToBotAPI($data);
    }
    /**
     * MTProto to TD params.
     *
     * @param mixed $params Params
     */
    public function MTProtoToTd(mixed &$params)
    {
        return $this->wrapper->getAPI()->MTProtoToTd($params);
    }
    /**
     * MTProto to TDCLI params.
     *
     * @param mixed $params Params
     */
    public function MTProtoToTdcli(mixed $params)
    {
        return $this->wrapper->getAPI()->MTProtoToTdcli($params);
    }
    /**
     * Accept call.
     *
     * @param array $call Call
     */
    public function acceptCall(array $call): bool
    {
        return $this->wrapper->getAPI()->acceptCall($call);
    }
    /**
     * Accept secret chat.
     *
     * @param array $params Secret chat ID
     */
    public function acceptSecretChat(array $params): void
    {
        $this->wrapper->getAPI()->acceptSecretChat($params);
    }
    /**
     * Add user info.
     *
     * @param array $user User info
     */
    public function addUser(array $user): void
    {
        $this->wrapper->getAPI()->addUser($user);
    }
    /**
     * Call promise $b after promise $a.
     *
     * @deprecated Coroutines are deprecated since amp v3
     * @param Generator|Future $a Promise A
     * @param Generator|Future $b Promise B
     * @psalm-suppress InvalidScope
     */
    public static function after(\Generator|\Amp\Future $a, \Generator|\Amp\Future $b): \Amp\Future
    {
        return \danog\MadelineProto\AsyncTools::after($a, $b);
    }
    /**
     * Returns a promise that succeeds when all promises succeed, and fails if any promise fails.
     * Returned promise succeeds with an array of values used to succeed each contained promise, with keys corresponding to the array of promises.
     *
     * @deprecated Coroutines are deprecated since amp v3
     * @param array<(Generator|Future)> $promises Promises
     */
    public static function all(array $promises)
    {
        return \danog\MadelineProto\AsyncTools::all($promises);
    }
    /**
     * Returns a promise that is resolved when all promises are resolved. The returned promise will not fail.
     *
     * @deprecated Coroutines are deprecated since amp v3
     * @param array<(Future|Generator)> $promises Promises
     */
    public static function any(array $promises)
    {
        return \danog\MadelineProto\AsyncTools::any($promises);
    }
    /**
     * Create array.
     *
     * @param mixed ...$params Params
     */
    public static function arr(mixed ...$params): array
    {
        return \danog\MadelineProto\Tools::arr(...$params);
    }
    /**
     * base64URL decode.
     *
     * @param string $data Data to decode
     */
    public static function base64urlDecode(string $data): string
    {
        return \danog\MadelineProto\Tools::base64urlDecode($data);
    }
    /**
     * Base64URL encode.
     *
     * @param string $data Data to encode
     */
    public static function base64urlEncode(string $data): string
    {
        return \danog\MadelineProto\Tools::base64urlEncode($data);
    }
    /**
     * Convert bot API parameters to MTProto parameters.
     *
     * @param array $arguments Arguments
     */
    public function botAPIToMTProto(array $arguments): array
    {
        return $this->wrapper->getAPI()->botAPIToMTProto($arguments);
    }
    /**
     * Login as bot.
     *
     * @param string $token Bot token
     */
    public function botLogin(string $token): ?array
    {
        return $this->wrapper->getAPI()->botLogin($token);
    }
    /**
     * Convert generator, promise or any other value to a promise.
     *
     * @deprecated Coroutines are deprecated since amp v3
     * @template TReturn
     * @param Generator<mixed, mixed, mixed, TReturn>|Future<TReturn>|TReturn $promise
     * @return Future<TReturn>
     */
    public static function call(mixed $promise): \Amp\Future
    {
        return \danog\MadelineProto\AsyncTools::call($promise);
    }
    /**
     * Call promise in background.
     *
     * @deprecated Coroutines are deprecated since amp v3
     * @param Generator|Future $promise Promise to resolve
     * @param ?\Generator|Future $actual  Promise to resolve instead of $promise
     * @param string              $file    File
     * @psalm-suppress InvalidScope
     */
    public static function callFork(\Generator|\Amp\Future $promise, $actual = null, string $file = ''): mixed
    {
        return \danog\MadelineProto\AsyncTools::callFork($promise, $actual, $file);
    }
    /**
     * Call promise in background, deferring execution.
     *
     * @deprecated Coroutines are deprecated since amp v3
     * @param Generator|Future $promise Promise to resolve
     */
    public static function callForkDefer(\Generator|\Amp\Future $promise): void
    {
        \danog\MadelineProto\AsyncTools::callForkDefer($promise);
    }
    /**
     * Get call status.
     *
     * @param int $id Call ID
     */
    public function callStatus(int $id): int
    {
        return $this->wrapper->getAPI()->callStatus($id);
    }
    /**
     * Close connection with client, connected via web.
     *
     * @param string $message Message
     */
    public static function closeConnection(string $message): void
    {
        \danog\MadelineProto\Tools::closeConnection($message);
    }
    /**
     * Complete 2FA login.
     *
     * @param string $password Password
     */
    public function complete2faLogin(string $password)
    {
        return $this->wrapper->getAPI()->complete2faLogin($password);
    }
    /**
     * Complete call handshake.
     *
     * @param array $params Params
     */
    public function completeCall(array $params)
    {
        return $this->wrapper->getAPI()->completeCall($params);
    }
    /**
     * Complet user login using login code.
     *
     * @param string $code Login code
     */
    public function completePhoneLogin(string $code)
    {
        return $this->wrapper->getAPI()->completePhoneLogin($code);
    }
    /**
     * Complete signup to Telegram.
     *
     * @param string $first_name First name
     * @param string $last_name  Last name
     */
    public function completeSignup(string $first_name, string $last_name = '')
    {
        return $this->wrapper->getAPI()->completeSignup($first_name, $last_name);
    }
    /**
     * Confirm call.
     *
     * @param array $params Params
     */
    public function confirmCall(array $params)
    {
        return $this->wrapper->getAPI()->confirmCall($params);
    }
    /**
     * Connects to all datacenters and if necessary creates authorization keys, binds them and writes client info.
     *
     * @param boolean $reconnectAll Whether to reconnect to all DCs
     */
    public function connectToAllDcs(bool $reconnectAll = true): void
    {
        $this->wrapper->getAPI()->connectToAllDcs($reconnectAll);
    }
    /**
     * Discard call.
     *
     * @param array   $call       Call
     * @param array   $rating     Rating
     * @param boolean $need_debug Need debug?
     */
    public function discardCall(array $call, array $reason, array $rating = [
    ], bool $need_debug = true): ?\danog\MadelineProto\VoIP
    {
        return $this->wrapper->getAPI()->discardCall($call, $reason, $rating, $need_debug);
    }
    /**
     * Discard secret chat.
     *
     * @param int $chat Secret chat ID
     */
    public function discardSecretChat(int $chat): void
    {
        $this->wrapper->getAPI()->discardSecretChat($chat);
    }
    /**
     * Download file to browser.
     *
     * Supports HEAD requests and content-ranges for parallel and resumed downloads.
     *
     * @param array|string|FileCallbackInterface $messageMedia File to download
     * @param null|callable     $cb           Status callback (can also use FileCallback)
     * @param null|int $size Size of file to download, required for bot API file IDs.
     * @param null|string $mime MIME type of file to download, required for bot API file IDs.
     * @param null|string $name Name of file to download, required for bot API file IDs.
     */
    public function downloadToBrowser(\danog\MadelineProto\FileCallbackInterface|array|string $messageMedia, ?callable $cb = null, ?int $size = null, ?string $name = null, ?string $mime = null): void
    {
        $this->wrapper->getAPI()->downloadToBrowser($messageMedia, $cb, $size, $name, $mime);
    }
    /**
     * Download file to callable.
     * The callable must accept two parameters: string $payload, int $offset
     * The callable will be called (possibly out of order, depending on the value of $seekable).
     *
     * @param mixed                          $messageMedia  File to download
     * @param callable|FileCallbackInterface $callable      Chunk callback
     * @param callable                       $cb            Status callback (DEPRECATED, use FileCallbackInterface)
     * @param bool                           $seekable      Whether the callable can be called out of order
     * @param int                            $offset        Offset where to start downloading
     * @param int                            $end           Offset where to stop downloading (inclusive)
     * @param int                            $part_size     Size of each chunk
     */
    public function downloadToCallable(mixed $messageMedia, callable $callable, ?callable $cb = null, bool $seekable = true, int $offset = 0, int $end = -1, ?int $part_size = null)
    {
        return $this->wrapper->getAPI()->downloadToCallable($messageMedia, $callable, $cb, $seekable, $offset, $end, $part_size);
    }
    /**
     * Download file to directory.
     *
     * @param mixed                        $messageMedia File to download
     * @param string|FileCallbackInterface $dir           Directory where to download the file
     * @param callable                     $cb            Callback (DEPRECATED, use FileCallbackInterface)
     */
    public function downloadToDir(mixed $messageMedia, \danog\MadelineProto\FileCallbackInterface|string $dir, ?callable $cb = null)
    {
        return $this->wrapper->getAPI()->downloadToDir($messageMedia, $dir, $cb);
    }
    /**
     * Download file.
     *
     * @param mixed                        $messageMedia File to download
     * @param string|FileCallbackInterface $file          Downloaded file path
     * @param callable                     $cb            Callback (DEPRECATED, use FileCallbackInterface)
     */
    public function downloadToFile(mixed $messageMedia, \danog\MadelineProto\FileCallbackInterface|string $file, ?callable $cb = null): string|false
    {
        return $this->wrapper->getAPI()->downloadToFile($messageMedia, $file, $cb);
    }
    /**
     * Download file to amphp/http-server response.
     *
     * Supports HEAD requests and content-ranges for parallel and resumed downloads.
     *
     * @param array|string|FileCallbackInterface  $messageMedia File to download
     * @param ServerRequest $request      Request
     * @param callable      $cb           Status callback (can also use FileCallback)
     * @param null|int          $size         Size of file to download, required for bot API file IDs.
     * @param null|string       $name         Name of file to download, required for bot API file IDs.
     * @param null|string       $mime         MIME type of file to download, required for bot API file IDs.
     */
    public function downloadToResponse(\danog\MadelineProto\FileCallbackInterface|array|string $messageMedia, \Amp\Http\Server\Request $request, ?callable $cb = null, ?int $size = null, ?string $mime = null, ?string $name = null): \Amp\Http\Server\Response
    {
        return $this->wrapper->getAPI()->downloadToResponse($messageMedia, $request, $cb, $size, $mime, $name);
    }
    /**
     * Download file to stream.
     *
     * @param mixed                       $messageMedia File to download
     * @param mixed|FileCallbackInterface|resource|WritableStream $stream        Stream where to download file
     * @param callable                    $cb            Callback (DEPRECATED, use FileCallbackInterface)
     * @param int                         $offset        Offset where to start downloading
     * @param int                         $end           Offset where to end download
     */
    public function downloadToStream(mixed $messageMedia, mixed $stream, ?callable $cb = null, int $offset = 0, int $end = -1)
    {
        return $this->wrapper->getAPI()->downloadToStream($messageMedia, $stream, $cb, $offset, $end);
    }
    /**
     * Asynchronously write to stdout/browser.
     *
     * @param string $string Message to echo
     */
    public static function echo(string $string): void
    {
        \danog\MadelineProto\AsyncTools::echo($string);
    }
    /**
     * Get final element of array.
     *
     * @param array $what Array
     */
    public static function end(array $what)
    {
        return \danog\MadelineProto\Tools::end($what);
    }
    /**
     * Export authorization.
     *
     * @return array{0: (int|string), 1: string}
     */
    public function exportAuthorization(): array
    {
        return $this->wrapper->getAPI()->exportAuthorization();
    }
    /**
     * Extract file info from bot API message.
     *
     * @param array $info Bot API message object
     */
    public static function extractBotAPIFile(array $info): ?array
    {
        return \danog\MadelineProto\MTProto::extractBotAPIFile($info);
    }
    /**
     * Extract a message constructor from an Updates constructor.
     */
    public function extractMessage(array $updates): array
    {
        return $this->wrapper->getAPI()->extractMessage($updates);
    }
    /**
     * Extract a message ID from an Updates constructor.
     */
    public function extractMessageId(array $updates): int
    {
        return $this->wrapper->getAPI()->extractMessageId($updates);
    }
    /**
     * Extract an update message constructor from an Updates constructor.
     */
    public function extractMessageUpdate(array $updates): array
    {
        return $this->wrapper->getAPI()->extractMessageUpdate($updates);
    }
    /**
     * Extract Update constructors from an Updates constructor.
     *
     * @return array<array>
     */
    public function extractUpdates(array $updates): array
    {
        return $this->wrapper->getAPI()->extractUpdates($updates);
    }
    /**
     * Get contents of remote file asynchronously.
     *
     * @param string $url URL
     */
    public function fileGetContents(string $url): string
    {
        return $this->wrapper->getAPI()->fileGetContents($url);
    }
    /**
     * Returns a promise that succeeds when the first promise succeeds, and fails only if all promises fail.
     *
     * @deprecated Coroutines are deprecated since amp v3
     * @param array<(Future|Generator)> $promises Promises
     */
    public static function first(array $promises)
    {
        return \danog\MadelineProto\AsyncTools::first($promises);
    }
    /**
     * Asynchronously lock a file
     * Resolves with a callbable that MUST eventually be called in order to release the lock.
     *
     * @param string    $file      File to lock
     * @param integer   $operation Locking mode
     * @param float     $polling   Polling interval
     * @param ?Cancellation $token     Cancellation token
     * @param ?Closure $failureCb Failure callback, called only once if the first locking attempt fails.
     * @return ($token is null ? (Closure(): void) : ((Closure(): void)|null))
     */
    public static function flock(string $file, int $operation, float $polling = 0.1, ?\Amp\Cancellation $token = null, ?\Closure $failureCb = null): ?\Closure
    {
        return \danog\MadelineProto\AsyncTools::flock($file, $operation, $polling, $token, $failureCb);
    }
    /**
     * Convert bot API channel ID to MTProto channel ID.
     *
     * @param int $id Bot API channel ID
     */
    public static function fromSupergroup(int $id): int
    {
        return \danog\MadelineProto\MTProto::fromSupergroup($id);
    }
    /**
     * When were full info for this chat last cached.
     *
     * @param mixed $id Chat ID
     */
    public function fullChatLastUpdated(mixed $id): int
    {
        return $this->wrapper->getAPI()->fullChatLastUpdated($id);
    }
    /**
     * Get info about the logged-in user, not cached.
     */
    public function fullGetSelf(): array|false
    {
        return $this->wrapper->getAPI()->fullGetSelf();
    }
    /**
     * Generate MTProto vector hash.
     *
     * @param array $ints IDs
     * @return string Vector hash
     */
    public static function genVectorHash(array $ints): string
    {
        return \danog\MadelineProto\Tools::genVectorHash($ints);
    }
    /**
     * Get full list of MTProto and API methods.
     */
    public function getAllMethods(): array
    {
        return $this->wrapper->getAPI()->getAllMethods();
    }
    /**
     * Get authorization info.
     */
    public function getAuthorization(): int
    {
        return $this->wrapper->getAPI()->getAuthorization();
    }
    /**
     * Get cached server-side config.
     */
    public function getCachedConfig(): array
    {
        return $this->wrapper->getAPI()->getCachedConfig();
    }
    /**
     * Get call info.
     *
     * @param int $call Call ID
     */
    public function getCall(int $call): array
    {
        return $this->wrapper->getAPI()->getCall($call);
    }
    /**
     * Store RSA keys for CDN datacenters.
     */
    public function getCdnConfig(): void
    {
        $this->wrapper->getAPI()->getCdnConfig();
    }
    /**
     * Get cached (or eventually re-fetch) server-side config.
     *
     * @param array $config  Current config
     */
    public function getConfig(array $config = [
    ]): array
    {
        return $this->wrapper->getAPI()->getConfig($config);
    }
    /**
     * Get async DNS client.
     */
    public function getDNSClient(): \Amp\Dns\DnsResolver
    {
        return $this->wrapper->getAPI()->getDNSClient();
    }
    /**
     * Get diffie-hellman configuration.
     */
    public function getDhConfig(): array
    {
        return $this->wrapper->getAPI()->getDhConfig();
    }
    /**
     * Get dialog IDs.
     *
     * @return list<int>
     */
    public function getDialogIds(): array
    {
        return $this->wrapper->getAPI()->getDialogIds();
    }
    /**
     * Get dialog peers.
     *
     * @return list<array>
     */
    public function getDialogs(): array
    {
        return $this->wrapper->getAPI()->getDialogs();
    }
    /**
     * Get download info of file
     * Returns an array with the following structure:.
     *
     * `$info['ext']` - The file extension
     * `$info['name']` - The file name, without the extension
     * `$info['mime']` - The file mime type
     * `$info['size']` - The file size
     *
     * @param mixed $messageMedia File ID
     */
    public function getDownloadInfo(mixed $messageMedia): array
    {
        return $this->wrapper->getAPI()->getDownloadInfo($messageMedia);
    }
    /**
     * Get event handler.
     */
    public function getEventHandler(): \danog\MadelineProto\EventHandler|\__PHP_Incomplete_Class|null
    {
        return $this->wrapper->getAPI()->getEventHandler();
    }
    /**
     * Get extension from file location.
     *
     * @param mixed  $location File location
     * @param string $default  Default extension
     */
    public static function getExtensionFromLocation(mixed $location, string $default): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getExtensionFromLocation($location, $default);
    }
    /**
     * Get extension from mime type.
     *
     * @param string $mime MIME type
     */
    public static function getExtensionFromMime(string $mime): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getExtensionFromMime($mime);
    }
    /**
     * Get info about file.
     *
     * @param mixed $constructor File ID
     */
    public function getFileInfo(mixed $constructor): array
    {
        return $this->wrapper->getAPI()->getFileInfo($constructor);
    }
    /**
     * Get folder ID from object.
     *
     * @param mixed $id Object
     */
    public static function getFolderId(mixed $id): ?int
    {
        return \danog\MadelineProto\MTProto::getFolderId($id);
    }
    /**
     * Get full info of all dialogs.
     *
     * Bots should use getDialogs or getDialogIds, instead.
     *
     * @return array<int, array>
     */
    public function getFullDialogs(): array
    {
        return $this->wrapper->getAPI()->getFullDialogs();
    }
    /**
     * Get full info about peer, returns an FullInfo object.
     *
     * @param mixed $id Peer
     * @see https://docs.madelineproto.xyz/FullInfo.html
     */
    public function getFullInfo(mixed $id): array
    {
        return $this->wrapper->getAPI()->getFullInfo($id);
    }
    /**
     * Get async HTTP client.
     */
    public function getHTTPClient(): \Amp\Http\Client\HttpClient
    {
        return $this->wrapper->getAPI()->getHTTPClient();
    }
    /**
     * Get current password hint.
     */
    public function getHint(): string
    {
        return $this->wrapper->getAPI()->getHint();
    }
    /**
     * Get bot API ID from peer object.
     *
     * @param mixed $id Peer
     */
    public function getId(mixed $id): ?int
    {
        return $this->wrapper->getAPI()->getId($id);
    }
    /**
     * Get info about peer, returns an Info object.
     *
     * @param mixed                $id        Peer
     * @param MTProto::INFO_TYPE_* $type      Whether to generate an Input*, an InputPeer or the full set of constructors
     * @see https://docs.madelineproto.xyz/Info.html
     * @return ($type is MTProto::INFO_TYPE_ALL ? array{
     *      InputPeer: array{_: string, user_id?: int, access_hash?: int, min?: bool, chat_id?: int, channel_id?: int},
     *      Peer: array{_: string, user_id?: int, chat_id?: int, channel_id?: int},
     *      DialogPeer: array{_: string, peer: array{_: string, user_id?: int, chat_id?: int, channel_id?: int}},
     *      NotifyPeer: array{_: string, peer: array{_: string, user_id?: int, chat_id?: int, channel_id?: int}},
     *      InputDialogPeer: array{_: string, peer: array{_: string, user_id?: int, access_hash?: int, min?: bool, chat_id?: int, channel_id?: int}},
     *      InputNotifyPeer: array{_: string, peer: array{_: string, user_id?: int, access_hash?: int, min?: bool, chat_id?: int, channel_id?: int}},
     *      bot_api_id: int|string,
     *      user_id?: int,
     *      chat_id?: int,
     *      channel_id?: int,
     *      InputUser?: array{_: string, user_id?: int, access_hash?: int, min?: bool},
     *      InputChannel?: array{_: string, channel_id: int, access_hash: int, min: bool},
     *      type: string
     * } : ($type is MTProto::INFO_TYPE_ID ? int : array{_: string, user_id?: int, access_hash?: int, min?: bool, chat_id?: int, channel_id?: int}|array{_: string, user_id?: int, access_hash?: int, min?: bool}|array{_: string, channel_id: int, access_hash: int, min: bool}))
     */
    public function getInfo(mixed $id, int $type = \danog\MadelineProto\MTProto::INFO_TYPE_ALL): array|int
    {
        return $this->wrapper->getAPI()->getInfo($id, $type);
    }
    /**
     * Get logger.
     */
    public function getLogger(): \danog\MadelineProto\Logger
    {
        return $this->wrapper->getAPI()->getLogger();
    }
    /**
     * Get current number of memory-mapped regions, UNIX only.
     */
    public static function getMaps(): ?int
    {
        return \danog\MadelineProto\Tools::getMaps();
    }
    /**
     * Get maximum number of memory-mapped regions, UNIX only.
     * Use testFibers to get the maximum number of fibers on any platform.
     */
    public static function getMaxMaps(): ?int
    {
        return \danog\MadelineProto\Tools::getMaxMaps();
    }
    /**
     * Get TL namespaces.
     */
    public function getMethodNamespaces(): array
    {
        return $this->wrapper->getAPI()->getMethodNamespaces();
    }
    /**
     * Get namespaced methods (method => namespace).
     */
    public function getMethodsNamespaced(): array
    {
        return $this->wrapper->getAPI()->getMethodsNamespaced();
    }
    /**
     * Get mime type from buffer.
     *
     * @param string $buffer Buffer
     */
    public static function getMimeFromBuffer(string $buffer): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getMimeFromBuffer($buffer);
    }
    /**
     * Get mime type from file extension.
     *
     * @param string $extension File extension
     * @param string $default   Default mime type
     */
    public static function getMimeFromExtension(string $extension, string $default): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getMimeFromExtension($extension, $default);
    }
    /**
     * Get mime type of file.
     *
     * @param string $file File
     */
    public static function getMimeFromFile(string $file): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getMimeFromFile($file);
    }
    /**
     * Get download info of the propic of a user
     * Returns an array with the following structure:.
     *
     * `$info['ext']` - The file extension
     * `$info['name']` - The file name, without the extension
     * `$info['mime']` - The file mime type
     * `$info['size']` - The file size
     */
    public function getPropicInfo($data): array
    {
        return $this->wrapper->getAPI()->getPropicInfo($data);
    }
    /**
     * Get PSR logger.
     */
    public function getPsrLogger(): \Psr\Log\LoggerInterface
    {
        return $this->wrapper->getAPI()->getPsrLogger();
    }
    /**
     * Get full info about peer (including full list of channel members), returns a Chat object.
     *
     * @param mixed $id Peer
     * @see https://docs.madelineproto.xyz/Chat.html
     */
    public function getPwrChat(mixed $id, bool $fullfetch = true): array
    {
        return $this->wrapper->getAPI()->getPwrChat($id, $fullfetch);
    }
    /**
     * Get secret chat.
     *
     * @param array|int $chat Secret chat ID
     */
    public function getSecretChat(array|int $chat): array
    {
        return $this->wrapper->getAPI()->getSecretChat($chat);
    }
    /**
     * Get info about the logged-in user, cached.
     *
     * Use fullGetSelf to bypass the cache.
     */
    public function getSelf(): array|false
    {
        return $this->wrapper->getAPI()->getSelf();
    }
    /**
     * Returns the session name.
     */
    public function getSessionName(): string
    {
        return $this->wrapper->getAPI()->getSessionName();
    }
    /**
     * Return current settings.
     */
    public function getSettings(): \danog\MadelineProto\Settings
    {
        return $this->wrapper->getAPI()->getSettings();
    }
    /**
     * Get sponsored messages for channel.
     * This method will return an array of [sponsored message objects](https://docs.madelineproto.xyz/API_docs/constructors/sponsoredMessage.html).
     *
     * See [the API documentation](https://core.telegram.org/api/sponsored-messages) for more info on how to handle sponsored messages.
     *
     * @param int|string|array $peer Channel ID, or Update, or Message, or Peer.
     */
    public function getSponsoredMessages(array|string|int $peer): array
    {
        return $this->wrapper->getAPI()->getSponsoredMessages($peer);
    }
    /**
     * Get TL serializer.
     */
    public function getTL(): \danog\MadelineProto\TL\TL
    {
        return $this->wrapper->getAPI()->getTL();
    }
    /**
     * Get updates.
     *
     * @param array{offset?: int, limit?: int, timeout?: float} $params Params
     * @return list<array{update_id: mixed, update: mixed}>
     */
    public function getUpdates(array $params = [
    ]): array
    {
        return $this->wrapper->getAPI()->getUpdates($params);
    }
    /**
     * Accesses a private variable from an object.
     *
     * @param object $obj Object
     * @param string $var Attribute name
     * @psalm-suppress InvalidScope
     * @access public
     */
    public static function getVar(object $obj, string $var)
    {
        return \danog\MadelineProto\Tools::getVar($obj, $var);
    }
    /**
     * Get a message to show to the user when starting the bot.
     */
    public function getWebMessage(string $message): string
    {
        return $this->wrapper->getAPI()->getWebMessage($message);
    }
    /**
     * Get web template.
     */
    public function getWebTemplate(): string
    {
        return $this->wrapper->getAPI()->getWebTemplate();
    }
    /**
     * Checks whether all datacenters are authorized.
     */
    public function hasAllAuth(): bool
    {
        return $this->wrapper->getAPI()->hasAllAuth();
    }
    /**
     * Check if an event handler instance is present.
     */
    public function hasEventHandler(): bool
    {
        return $this->wrapper->getAPI()->hasEventHandler();
    }
    /**
     * Check if has report peers.
     */
    public function hasReportPeers(): bool
    {
        return $this->wrapper->getAPI()->hasReportPeers();
    }
    /**
     * Check whether secret chat exists.
     *
     * @param array|int $chat Secret chat ID
     */
    public function hasSecretChat(array|int $chat): bool
    {
        return $this->wrapper->getAPI()->hasSecretChat($chat);
    }
    /**
     * Checks private property exists in an object.
     *
     * @param object $obj Object
     * @param string $var Attribute name
     * @psalm-suppress InvalidScope
     * @access public
     */
    public static function hasVar(object $obj, string $var): bool
    {
        return \danog\MadelineProto\Tools::hasVar($obj, $var);
    }
    /**
     * Import authorization.
     *
     * @param array<int, string> $authorization Authorization info
     * @param int $mainDcID Main DC ID
     */
    public function importAuthorization(array $authorization, int $mainDcID)
    {
        return $this->wrapper->getAPI()->importAuthorization($authorization, $mainDcID);
    }
    /**
     * Inflate stripped photosize to full JPG payload.
     *
     * @param string $stripped Stripped photosize
     * @return string JPG payload
     */
    public static function inflateStripped(string $stripped): string
    {
        return \danog\MadelineProto\Tools::inflateStripped($stripped);
    }
    /**
     * Initialize self-restart hack.
     */
    public function initSelfRestart(): void
    {
        $this->wrapper->getAPI()->initSelfRestart();
    }
    /**
     * Whether this is altervista.
     */
    public static function isAltervista(): bool
    {
        return \danog\MadelineProto\Tools::isAltervista();
    }
    /**
     * Check if is array or similar (traversable && countable && arrayAccess).
     *
     * @param mixed $var Value to check
     */
    public static function isArrayOrAlike(mixed $var): bool
    {
        return \danog\MadelineProto\Tools::isArrayOrAlike($var);
    }
    /**
     * Whether we're an IPC client instance.
     */
    public function isIpc(): bool
    {
        return $this->wrapper->getAPI()->isIpc();
    }
    /**
     * Whether we're an IPC server process (as opposed to an event handler).
     */
    public function isIpcWorker(): bool
    {
        return $this->wrapper->getAPI()->isIpcWorker();
    }
    /**
     * Returns whether the current user is a premium user, cached.
     */
    public function isPremium(): bool
    {
        return $this->wrapper->getAPI()->isPremium();
    }
    /**
     * Check whether provided bot API ID is a channel.
     *
     * @param int $id Bot API ID
     */
    public static function isSupergroup(int $id): bool
    {
        return \danog\MadelineProto\MTProto::isSupergroup($id);
    }
    /**
     * Logger.
     *
     * @param mixed  $param Parameter
     * @param int    $level Logging level
     * @param string $file  File where the message originated
     */
    public function logger(mixed $param, int $level = \danog\MadelineProto\Logger::NOTICE, string $file = ''): void
    {
        $this->wrapper->getAPI()->logger($param, $level, $file);
    }
    /**
     * Start MadelineProto's update handling loop, or run the provided async callable.
     *
     * @param callable|null $callback Async callable to run
     */
    public function loop(?callable $callback = null)
    {
        return $this->wrapper->getAPI()->loop($callback);
    }
    /**
     * Escape string for markdown.
     *
     * @param string $hwat String to escape
     */
    public static function markdownEscape(string $hwat): string
    {
        return \danog\MadelineProto\StrTools::markdownEscape($hwat);
    }
    /**
     * Telegram UTF-8 multibyte split.
     *
     * @param string  $text   Text
     * @param integer $length Length
     * @return array<string>
     */
    public static function mbStrSplit(string $text, int $length): array
    {
        return \danog\MadelineProto\StrTools::mbStrSplit($text, $length);
    }
    /**
     * Get Telegram UTF-8 length of string.
     *
     * @param string $text Text
     */
    public static function mbStrlen(string $text): int
    {
        return \danog\MadelineProto\StrTools::mbStrlen($text);
    }
    /**
     * Telegram UTF-8 multibyte substring.
     *
     * @param string  $text   Text to substring
     * @param integer $offset Offset
     * @param null|int    $length Length
     */
    public static function mbSubstr(string $text, int $offset, ?int $length = null): string
    {
        return \danog\MadelineProto\StrTools::mbSubstr($text, $offset, $length);
    }
    /**
     * Escape method name.
     *
     * @param string $method Method name
     */
    public static function methodEscape(string $method): string
    {
        return \danog\MadelineProto\StrTools::methodEscape($method);
    }
    /**
     * Convert double to binary version.
     *
     * @param float $value Value to convert
     */
    public static function packDouble(float $value): string
    {
        return \danog\MadelineProto\Tools::packDouble($value);
    }
    /**
     * Convert integer to base256 signed int.
     *
     * @param integer $value Value to convert
     */
    public static function packSignedInt(int $value): string
    {
        return \danog\MadelineProto\Tools::packSignedInt($value);
    }
    /**
     * Convert integer to base256 long.
     *
     * @param int $value Value to convert
     */
    public static function packSignedLong(int $value): string
    {
        return \danog\MadelineProto\Tools::packSignedLong($value);
    }
    /**
     * Convert value to unsigned base256 int.
     *
     * @param int $value Value
     */
    public static function packUnsignedInt(int $value): string
    {
        return \danog\MadelineProto\Tools::packUnsignedInt($value);
    }
    /**
     * Check if peer is present in internal peer database.
     *
     * @param mixed $id Peer
     */
    public function peerIsset(mixed $id): bool
    {
        return $this->wrapper->getAPI()->peerIsset($id);
    }
    /**
     * Login as user.
     *
     * @param string  $number   Phone number
     * @param integer $sms_type SMS type
     */
    public function phoneLogin(string $number, int $sms_type = 5)
    {
        return $this->wrapper->getAPI()->phoneLogin($number, $sms_type);
    }
    /**
     * Positive modulo
     * Works just like the % (modulus) operator, only returns always a postive number.
     *
     * @param int $a A
     * @param int $b B
     * @return int Modulo
     */
    public static function posmod(int $a, int $b): int
    {
        return \danog\MadelineProto\Tools::posmod($a, $b);
    }
    /**
     * Get random string of specified length.
     *
     * @param integer $length Length
     * @return string Random string
     */
    public static function random(int $length): string
    {
        return \danog\MadelineProto\Tools::random($length);
    }
    /**
     * Get random integer.
     *
     * @param integer $modulus Modulus
     */
    public static function randomInt(int $modulus = 0): int
    {
        return \danog\MadelineProto\Tools::randomInt($modulus);
    }
    /**
     * Asynchronously read line.
     *
     * @param string $prompt Prompt
     */
    public static function readLine(string $prompt = ''): string
    {
        return \danog\MadelineProto\AsyncTools::readLine($prompt);
    }
    /**
     * Refresh full peer cache for a certain peer.
     *
     * @param mixed $id The peer to refresh
     */
    public function refreshFullPeerCache(mixed $id): void
    {
        $this->wrapper->getAPI()->refreshFullPeerCache($id);
    }
    /**
     * Refresh peer cache for a certain peer.
     *
     */
    public function refreshPeerCache(mixed ...$ids): void
    {
        $this->wrapper->getAPI()->refreshPeerCache(...$ids);
    }
    /**
     * Rekey secret chat.
     *
     * @param int $chat Secret chat to rekey
     */
    public function rekey(int $chat): ?string
    {
        return $this->wrapper->getAPI()->rekey($chat);
    }
    /**
     * Report an error to the previously set peer.
     *
     * @param string $message   Error to report
     * @param string $parseMode Parse mode
     */
    public function report(string $message, string $parseMode = ''): void
    {
        $this->wrapper->getAPI()->report($message, $parseMode);
    }
    /**
     * Request VoIP call.
     *
     * @param mixed $user User
     */
    public function requestCall(mixed $user)
    {
        return $this->wrapper->getAPI()->requestCall($user);
    }
    /**
     * Request secret chat.
     *
     * @param mixed $user User to start secret chat with
     */
    public function requestSecretChat(mixed $user)
    {
        return $this->wrapper->getAPI()->requestSecretChat($user);
    }
    /**
     * Reset the update state and fetch all updates from the beginning.
     */
    public function resetUpdateState(): void
    {
        $this->wrapper->getAPI()->resetUpdateState();
    }
    /**
     * Rethrow exception into event loop.
     */
    public static function rethrow(\Throwable $e): void
    {
        \danog\MadelineProto\AsyncTools::rethrow($e);
    }
    /**
     * null-byte RLE decode.
     *
     * @param string $string Data to decode
     */
    public static function rleDecode(string $string): string
    {
        return \danog\MadelineProto\Tools::rleDecode($string);
    }
    /**
     * null-byte RLE encode.
     *
     * @param string $string Data to encode
     */
    public static function rleEncode(string $string): string
    {
        return \danog\MadelineProto\Tools::rleEncode($string);
    }
    /**
     * Get secret chat status.
     *
     * @param int $chat Chat ID
     * @return int One of MTProto::SECRET_EMPTY, MTProto::SECRET_REQUESTED, MTProto::SECRET_READY
     */
    public function secretChatStatus(int $chat): int
    {
        return $this->wrapper->getAPI()->secretChatStatus($chat);
    }
    /**
     * Set NOOP update handler, ignoring all updates.
     */
    public function setNoop(): void
    {
        $this->wrapper->getAPI()->setNoop();
    }
    /**
     * Set peer(s) where to send errors occurred in the event loop.
     *
     * @param int|string|array<int|string> $userOrId Username(s) or peer ID(s)
     */
    public function setReportPeers(array|string|int $userOrId): void
    {
        $this->wrapper->getAPI()->setReportPeers($userOrId);
    }
    /**
     * Sets a private variable in an object.
     *
     * @param object $obj Object
     * @param string $var Attribute name
     * @param mixed  $val Attribute value
     * @psalm-suppress InvalidScope
     * @access public
     */
    public static function setVar(object $obj, string $var, mixed &$val): void
    {
        \danog\MadelineProto\Tools::setVar($obj, $var, $val);
    }
    /**
     * Set web template.
     *
     * @param string $template Template
     */
    public function setWebTemplate(string $template): void
    {
        $this->wrapper->getAPI()->setWebTemplate($template);
    }
    /**
     * Set webhook update handler.
     *
     * @param string $webhookUrl Webhook URL
     */
    public function setWebhook(string $webhookUrl): void
    {
        $this->wrapper->getAPI()->setWebhook($webhookUrl);
    }
    /**
     * Setup logger.
     */
    public function setupLogger(): void
    {
        $this->wrapper->getAPI()->setupLogger();
    }
    /**
     * Asynchronously sleep.
     *
     * @param float $time Number of seconds to sleep for
     */
    public static function sleep(float $time): void
    {
        \danog\MadelineProto\AsyncTools::sleep($time);
    }
    /**
     * Resolves with a two-item array delineating successful and failed Promise results.
     * The returned promise will only fail if the given number of required promises fail.
     *
     * @deprecated Coroutines are deprecated since amp v3
     * @param array<(Future|Generator)> $promises Promises
     */
    public static function some(array $promises)
    {
        return \danog\MadelineProto\AsyncTools::some($promises);
    }
    /**
     * Log in to telegram (via CLI or web).
     */
    public function start()
    {
        return $this->wrapper->getAPI()->start();
    }
    /**
     * Subscribe to event handler updates for a channel/supergroup we're not a member of.
     *
     * @return bool False if we were already subscribed
     */
    public function subscribeToUpdates(mixed $channel): bool
    {
        return $this->wrapper->getAPI()->subscribeToUpdates($channel);
    }
    /**
     * Convert TD to MTProto parameters.
     *
     * @param array $params Parameters
     */
    public function tdToMTProto(array $params): array
    {
        return $this->wrapper->getAPI()->tdToMTProto($params);
    }
    /**
     * Convert TD parameters to tdcli.
     *
     * @param mixed $params Parameters
     */
    public function tdToTdcli(mixed $params)
    {
        return $this->wrapper->getAPI()->tdToTdcli($params);
    }
    /**
     * Convert tdcli parameters to tdcli.
     *
     * @param mixed $params Params
     * @param array $key    Key
     */
    public function tdcliToTd(&$params, ?array $key = null): array
    {
        return $this->wrapper->getAPI()->tdcliToTd($params, $key);
    }
    /**
     * Test fibers.
     *
     * @return array{maxFibers: int, realMemoryMb: int, maps: ?int, maxMaps: ?int}
     */
    public static function testFibers(int $fiberCount = 100000): array
    {
        return \danog\MadelineProto\Tools::testFibers($fiberCount);
    }
    /**
     * Create an artificial timeout for any Generator or Promise.
     *
     * @deprecated Coroutines are deprecated since amp v3
     * @param int $timeout In milliseconds
     */
    public static function timeout(\Generator|\Amp\Future $promise, int $timeout): mixed
    {
        return \danog\MadelineProto\AsyncTools::timeout($promise, $timeout);
    }
    /**
     * Creates an artificial timeout for any `Promise`.
     *
     * If the promise is resolved before the timeout expires, the result is returned
     *
     * If the timeout expires before the promise is resolved, a default value is returned
     *
     * @deprecated Coroutines are deprecated since amp v3
     * @template TReturnAlt
     * @template TReturn
     * @template TGenerator of Generator<mixed, mixed, mixed, TReturn>
     * @param Future<TReturn>|TGenerator $promise Promise to which the timeout is applied.
     * @param int                        $timeout Timeout in milliseconds.
     * @param TReturnAlt                 $default
     * @return TReturn|TReturnAlt
     */
    public static function timeoutWithDefault($promise, int $timeout, $default = null): mixed
    {
        return \danog\MadelineProto\AsyncTools::timeoutWithDefault($promise, $timeout, $default);
    }
    /**
     * Convert to camelCase.
     *
     * @param string $input String
     */
    public static function toCamelCase(string $input): string
    {
        return \danog\MadelineProto\StrTools::toCamelCase($input);
    }
    /**
     * Convert to snake_case.
     *
     * @param string $input String
     */
    public static function toSnakeCase(string $input): string
    {
        return \danog\MadelineProto\StrTools::toSnakeCase($input);
    }
    /**
     * Convert MTProto channel ID to bot API channel ID.
     *
     * @param int $id MTProto channel ID
     */
    public static function toSupergroup(int $id): int
    {
        return \danog\MadelineProto\MTProto::toSupergroup($id);
    }
    /**
     * Escape type name.
     *
     * @param string $type String to escape
     */
    public static function typeEscape(string $type): string
    {
        return \danog\MadelineProto\StrTools::typeEscape($type);
    }
    /**
     * Unpack binary double.
     *
     * @param string $value Value to unpack
     */
    public static function unpackDouble(string $value): float
    {
        return \danog\MadelineProto\Tools::unpackDouble($value);
    }
    /**
     * Unpack bot API file ID.
     *
     * @param string $fileId Bot API file ID
     * @return array Unpacked file ID
     */
    public function unpackFileId(string $fileId): array
    {
        return $this->wrapper->getAPI()->unpackFileId($fileId);
    }
    /**
     * Unpack base256 signed int.
     *
     * @param string $value base256 int
     */
    public static function unpackSignedInt(string $value): int
    {
        return \danog\MadelineProto\Tools::unpackSignedInt($value);
    }
    /**
     * Unpack base256 signed long.
     *
     * @param string $value base256 long
     */
    public static function unpackSignedLong(string $value): int
    {
        return \danog\MadelineProto\Tools::unpackSignedLong($value);
    }
    /**
     * Unpack base256 signed long to string.
     *
     * @param string|int|array $value base256 long
     */
    public static function unpackSignedLongString(array|string|int $value): string
    {
        return \danog\MadelineProto\Tools::unpackSignedLongString($value);
    }
    /**
     * Unset event handler.
     *
     */
    public function unsetEventHandler(): void
    {
        $this->wrapper->getAPI()->unsetEventHandler();
    }
    /**
     * Update the 2FA password.
     *
     * The params array can contain password, new_password, email and hint params.
     *
     * @param array{password?: string, new_password?: string, email?: string, hint?: string} $params The params
     */
    public function update2fa(array $params): void
    {
        $this->wrapper->getAPI()->update2fa($params);
    }
    /**
     * Parse, update and store settings.
     *
     * @param SettingsAbstract $settings Settings
     */
    public function updateSettings(\danog\MadelineProto\SettingsAbstract $settings): void
    {
        $this->wrapper->getAPI()->updateSettings($settings);
    }
    /**
     * Upload file.
     *
     * @param FileCallbackInterface|string|array $file      File, URL or Telegram file to upload
     * @param string                             $fileName  File name
     * @param callable                           $cb        Callback (DEPRECATED, use FileCallbackInterface)
     * @param boolean                            $encrypted Whether to encrypt file for secret chats
     */
    public function upload(\danog\MadelineProto\FileCallbackInterface|array|string $file, string $fileName = '', ?callable $cb = null, bool $encrypted = false)
    {
        return $this->wrapper->getAPI()->upload($file, $fileName, $cb, $encrypted);
    }
    /**
     * Upload file to secret chat.
     *
     * @param FileCallbackInterface|string|array $file      File, URL or Telegram file to upload
     * @param string                             $fileName  File name
     * @param callable                           $cb        Callback (DEPRECATED, use FileCallbackInterface)
     */
    public function uploadEncrypted(\danog\MadelineProto\FileCallbackInterface|array|string $file, string $fileName = '', ?callable $cb = null)
    {
        return $this->wrapper->getAPI()->uploadEncrypted($file, $fileName, $cb);
    }
    /**
     * Upload file from callable.
     *
     * The callable must accept two parameters: int $offset, int $size
     * The callable must return a string with the contest of the file at the specified offset and size.
     *
     * @param mixed    $callable  Callable
     * @param integer  $size      File size
     * @param string   $mime      Mime type
     * @param string   $fileName  File name
     * @param callable $cb        Callback (DEPRECATED, use FileCallbackInterface)
     * @param boolean  $seekable  Whether chunks can be fetched out of order
     * @param boolean  $encrypted Whether to encrypt file for secret chats
     */
    public function uploadFromCallable(callable $callable, int $size, string $mime, string $fileName = '', ?callable $cb = null, bool $seekable = true, bool $encrypted = false)
    {
        return $this->wrapper->getAPI()->uploadFromCallable($callable, $size, $mime, $fileName, $cb, $seekable, $encrypted);
    }
    /**
     * Upload file from stream.
     *
     * @param mixed    $stream    PHP resource or AMPHP async stream
     * @param integer  $size      File size
     * @param string   $mime      Mime type
     * @param string   $fileName  File name
     * @param callable $cb        Callback (DEPRECATED, use FileCallbackInterface)
     * @param boolean  $encrypted Whether to encrypt file for secret chats
     */
    public function uploadFromStream(mixed $stream, int $size, string $mime, string $fileName = '', ?callable $cb = null, bool $encrypted = false)
    {
        return $this->wrapper->getAPI()->uploadFromStream($stream, $size, $mime, $fileName, $cb, $encrypted);
    }
    /**
     * Reupload telegram file.
     *
     * @param mixed    $media     Telegram file
     * @param callable $cb        Callback (DEPRECATED, use FileCallbackInterface)
     * @param boolean  $encrypted Whether to encrypt file for secret chats
     */
    public function uploadFromTgfile(mixed $media, ?callable $cb = null, bool $encrypted = false)
    {
        return $this->wrapper->getAPI()->uploadFromTgfile($media, $cb, $encrypted);
    }
    /**
     * Upload file from URL.
     *
     * @param string|FileCallbackInterface $url       URL of file
     * @param integer                      $size      Size of file
     * @param string                       $fileName  File name
     * @param callable                     $cb        Callback (DEPRECATED, use FileCallbackInterface)
     * @param boolean                      $encrypted Whether to encrypt file for secret chats
     */
    public function uploadFromUrl(\danog\MadelineProto\FileCallbackInterface|string $url, int $size = 0, string $fileName = '', ?callable $cb = null, bool $encrypted = false)
    {
        return $this->wrapper->getAPI()->uploadFromUrl($url, $size, $fileName, $cb, $encrypted);
    }
    /**
     * Mark sponsored message as read.
     *
     * @param int|array $peer Channel ID, or Update, or Message, or Peer.
     * @param string|array{random_id: string} $message Random ID or sponsored message to mark as read.
     */
    public function viewSponsoredMessage(array|int $peer, array|string $message): bool
    {
        return $this->wrapper->getAPI()->viewSponsoredMessage($peer, $message);
    }
    /**
     * Synchronously wait for a Future|generator.
     *
     * @deprecated Coroutines are deprecated since amp v3
     * @param Generator|Future $promise The promise to wait for
     */
    public static function wait(\Generator|\Amp\Future $promise)
    {
        return \danog\MadelineProto\AsyncTools::wait($promise);
    }
}
