<?php
/**
 * This file is automatic generated by build_docs.php file
 * and is used only for autocomplete in multiple IDE
 * don't modify manually.
 */

namespace danog\MadelineProto\Namespace;

interface Stats
{
    /**
     * Get [channel statistics](https://core.telegram.org/api/stats)
     *
     * @param array|int|string $channel The channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $dark Whether to enable dark theme for graph colors
     * @return array{_: 'stats.broadcastStats', period: array{_: 'statsDateRangeDays', min_date: int, max_date: int}, followers: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, views_per_post: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, shares_per_post: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, enabled_notifications: array{_: 'statsPercentValue', part: float, total: float}, growth_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, followers_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, mute_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, top_hours_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, interactions_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, iv_interactions_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, views_by_source_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, new_followers_by_source_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, languages_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, recent_message_interactions: list<array{_: 'messageInteractionCounters', msg_id: int, views: int, forwards: int}>} @see https://docs.madelineproto.xyz/API_docs/types/stats.BroadcastStats.html
     */
    public function getBroadcastStats(array|int|string $channel, bool $dark = false): array;

    /**
     * Load [channel statistics graph](https://core.telegram.org/api/stats) asynchronously
     *
     * @param string $token Graph token from [statsGraphAsync](https://docs.madelineproto.xyz/API_docs/constructors/statsGraphAsync.html) constructor
     * @param int $x Zoom value, if required
     * @return array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string} @see https://docs.madelineproto.xyz/API_docs/types/StatsGraph.html
     */
    public function loadAsyncGraph(string $token = '', int $x = 0): array;

    /**
     * Get [supergroup statistics](https://core.telegram.org/api/stats)
     *
     * @param array|int|string $channel [Supergroup ID](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $dark Whether to enable dark theme for graph colors
     * @return array{_: 'stats.megagroupStats', period: array{_: 'statsDateRangeDays', min_date: int, max_date: int}, members: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, messages: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, viewers: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, posters: array{_: 'statsAbsValueAndPrev', current: float, previous: float}, growth_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, members_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, new_members_by_source_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, languages_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, messages_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, actions_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, top_hours_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, weekdays_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}, top_posters: list<array{_: 'statsGroupTopPoster', user_id: int, messages: int, avg_chars: int}>, top_admins: list<array{_: 'statsGroupTopAdmin', user_id: int, deleted: int, kicked: int, banned: int}>, top_inviters: list<array{_: 'statsGroupTopInviter', user_id: int, invitations: int}>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/stats.MegagroupStats.html
     */
    public function getMegagroupStats(array|int|string $channel, bool $dark = false): array;

    /**
     * Obtains a list of messages, indicating to which other public channels was a channel message forwarded.  
     * Will return a list of [messages](https://docs.madelineproto.xyz/API_docs/constructors/message.html) with `peer_id` equal to the public channel to which this message was forwarded.
     *
     * @param array|int|string $channel Source channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $offset_peer [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets) @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param int $msg_id Source message ID
     * @param int $offset_rate Initially 0, then set to the `next_rate` parameter of [messages.messagesSlice](https://docs.madelineproto.xyz/API_docs/constructors/messages.messagesSlice.html)
     * @param int $offset_id [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @return array{_: 'messages.messages', messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, id: int, from_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, from_id?: array|int|string, from_name: string, date: int, channel_post: int, post_author: string, saved_from_peer?: array|int|string, saved_from_msg_id: int, psa_type: string}, via_bot_id: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, reply_to_msg_id: int, reply_to_peer_id?: array|int|string, reply_to_top_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}, ttl_seconds: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_thumbs: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}, ttl_seconds: int}|array{_: 'messageMediaWebPage', webpage: array{_: 'webPageEmpty', id: int}|array{_: 'webPagePending', id: int, date: int}|array{_: 'webPage', id: int, url: string, display_url: string, hash: int, type: string, site_name: string, title: string, description: string, photo?: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_sizes: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int}, embed_url: string, embed_type: string, embed_width: int, embed_height: int, duration: int, author: string, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_thumbs: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: array, h: array}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array, mask: array, alt: array, mask_coords?: array}|array{_: 'documentAttributeVideo', round_message: array, supports_streaming: array, duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', voice: array, duration: array, title: array, performer: array, waveform: array}|array{_: 'documentAttributeFilename', file_name: array}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array, free: array, text_color: array, alt: array}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', duration: array}|array{_: 'documentAttributeSticker', stickerset: array, alt: array}|array{_: 'documentAttributeAudio', duration: array, title: array, performer: array}>}, cached_page?: array{_: 'page', part: bool, rtl: bool, v2: bool, url: string, blocks: list<array{_: 'pageBlockUnsupported'}|array{_: 'pageBlockTitle', text: array}|array{_: 'pageBlockSubtitle', text: array}|array{_: 'pageBlockAuthorDate', author: array, published_date: array}|array{_: 'pageBlockHeader', text: array}|array{_: 'pageBlockSubheader', text: array}|array{_: 'pageBlockParagraph', text: array}|array{_: 'pageBlockPreformatted', text: array, language: array}|array{_: 'pageBlockFooter', text: array}|array{_: 'pageBlockDivider'}|array{_: 'pageBlockAnchor', name: array}|array{_: 'pageBlockList', items: list<array>}|array{_: 'pageBlockBlockquote', text: array, caption: array}|array{_: 'pageBlockPullquote', text: array, caption: array}|array{_: 'pageBlockPhoto', caption: array, photo_id: array, url: array, webpage_id: array}|array{_: 'pageBlockVideo', caption: array, autoplay: array, loop: array, video_id: array}|array{_: 'pageBlockCover', cover: array}|array{_: 'pageBlockEmbed', caption: array, full_width: array, allow_scrolling: array, url: array, html: array, poster_photo_id: array, w: array, h: array}|array{_: 'pageBlockChannel', channel: array}|array{_: 'pageBlockAudio', caption: array, audio_id: array}|array{_: 'pageBlockKicker', text: array}|array{_: 'pageBlockTable', title: array, bordered: array, striped: array, rows: list<array>}|array{_: 'pageBlockOrderedList', items: list<array>}|array{_: 'pageBlockRelatedArticles', title: array, articles: list<array>}|array{_: 'pageBlockMap', geo: array, caption: array, zoom: array, w: array, h: array}>, photos: list<array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes: list<array>, dc_id: array}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs: list<array>, video_thumbs: list<array>, dc_id: array, attributes: list<array>}>, views: int}, attributes: list<array{_: 'webPageAttributeTheme', documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs: list<array>, video_thumbs: list<array>, dc_id: array, attributes: list<array>}>, settings?: array{_: 'themeSettings', base_theme: array, message_colors_animated: array, accent_color: array, outbox_accent_color: array, message_colors: list<array>, wallpaper?: array}}>}|array{_: 'webPageNotModified', cached_page_views: int}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_sizes: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int}, id: int, access_hash: int, short_name: string, title: string, description: string, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_thumbs: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: array, h: array}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array, mask: array, alt: array, mask_coords?: array}|array{_: 'documentAttributeVideo', round_message: array, supports_streaming: array, duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', voice: array, duration: array, title: array, performer: array, waveform: array}|array{_: 'documentAttributeFilename', file_name: array}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array, free: array, text_color: array, alt: array}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', duration: array}|array{_: 'documentAttributeSticker', stickerset: array, alt: array}|array{_: 'documentAttributeAudio', duration: array, title: array, performer: array}>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: string, access_hash: int, size: int, mime_type: string, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}|array{_: 'webDocumentNoProxy', url: string, size: int, mime_type: string, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}, receipt_msg_id: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w: int, h: int, thumb?: array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}, video_duration: int}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}, heading: int, period: int, proximity_notification_radius: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', id: int, closed: bool, public_voters: bool, multiple_choice: bool, quiz: bool, question: string, answers: list<array{_: 'pollAnswer', text: string, option: string}>, close_period: int, close_date: int}, results: array{_: 'pollResults', min: bool, results: list<array{_: 'pollAnswerVoters', chosen: bool, correct: bool, option: string, voters: int}>, total_voters: int, recent_voters: list<int>, solution: string, solution_entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>}}|array{_: 'messageMediaDice', value: int, emoticon: string}, reply_markup?: array, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>, views: int, forwards: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers: list<array|int|string>, channel_id: int, max_id: int, read_max_id: int}, edit_date: int, post_author: string, grouped_id: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, results: list<array{_: 'reactionCount', reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, chosen_order: int, count: int}>, recent_reactions: list<array{_: 'messagePeerReaction', peer_id: array|int|string, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, big: bool, unread: bool}>}, restriction_reason: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period: int}|array{_: 'messageService', peer_id: array|int|string, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', chat_id: array|int|string, title: string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name: string, phone: string, email: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', domain: string}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id: int}|array{_: 'messageActionTopicEdit', title: string, icon_emoji_id: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}}|array{_: 'messageActionAttachMenuBotAllowed'}|array{_: 'messageActionRequestedPeer', peer: array|int|string, button_id: int}, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, reply_to_msg_id: int, reply_to_peer_id?: array|int|string, reply_to_top_id: int}, date: int, ttl_period: int}>, chats: list<array|int|string>, users: list<array|int|string>}|array{_: 'messages.messagesSlice', inexact: bool, count: int, next_rate: int, offset_id_offset: int, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, id: int, from_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, from_id?: array|int|string, from_name: string, date: int, channel_post: int, post_author: string, saved_from_peer?: array|int|string, saved_from_msg_id: int, psa_type: string}, via_bot_id: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, reply_to_msg_id: int, reply_to_peer_id?: array|int|string, reply_to_top_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}, ttl_seconds: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_thumbs: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}, ttl_seconds: int}|array{_: 'messageMediaWebPage', webpage: array{_: 'webPageEmpty', id: int}|array{_: 'webPagePending', id: int, date: int}|array{_: 'webPage', id: int, url: string, display_url: string, hash: int, type: string, site_name: string, title: string, description: string, photo?: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_sizes: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int}, embed_url: string, embed_type: string, embed_width: int, embed_height: int, duration: int, author: string, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_thumbs: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: array, h: array}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array, mask: array, alt: array, mask_coords?: array}|array{_: 'documentAttributeVideo', round_message: array, supports_streaming: array, duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', voice: array, duration: array, title: array, performer: array, waveform: array}|array{_: 'documentAttributeFilename', file_name: array}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array, free: array, text_color: array, alt: array}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', duration: array}|array{_: 'documentAttributeSticker', stickerset: array, alt: array}|array{_: 'documentAttributeAudio', duration: array, title: array, performer: array}>}, cached_page?: array{_: 'page', part: bool, rtl: bool, v2: bool, url: string, blocks: list<array{_: 'pageBlockUnsupported'}|array{_: 'pageBlockTitle', text: array}|array{_: 'pageBlockSubtitle', text: array}|array{_: 'pageBlockAuthorDate', author: array, published_date: array}|array{_: 'pageBlockHeader', text: array}|array{_: 'pageBlockSubheader', text: array}|array{_: 'pageBlockParagraph', text: array}|array{_: 'pageBlockPreformatted', text: array, language: array}|array{_: 'pageBlockFooter', text: array}|array{_: 'pageBlockDivider'}|array{_: 'pageBlockAnchor', name: array}|array{_: 'pageBlockList', items: list<array>}|array{_: 'pageBlockBlockquote', text: array, caption: array}|array{_: 'pageBlockPullquote', text: array, caption: array}|array{_: 'pageBlockPhoto', caption: array, photo_id: array, url: array, webpage_id: array}|array{_: 'pageBlockVideo', caption: array, autoplay: array, loop: array, video_id: array}|array{_: 'pageBlockCover', cover: array}|array{_: 'pageBlockEmbed', caption: array, full_width: array, allow_scrolling: array, url: array, html: array, poster_photo_id: array, w: array, h: array}|array{_: 'pageBlockChannel', channel: array}|array{_: 'pageBlockAudio', caption: array, audio_id: array}|array{_: 'pageBlockKicker', text: array}|array{_: 'pageBlockTable', title: array, bordered: array, striped: array, rows: list<array>}|array{_: 'pageBlockOrderedList', items: list<array>}|array{_: 'pageBlockRelatedArticles', title: array, articles: list<array>}|array{_: 'pageBlockMap', geo: array, caption: array, zoom: array, w: array, h: array}>, photos: list<array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes: list<array>, dc_id: array}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs: list<array>, video_thumbs: list<array>, dc_id: array, attributes: list<array>}>, views: int}, attributes: list<array{_: 'webPageAttributeTheme', documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs: list<array>, video_thumbs: list<array>, dc_id: array, attributes: list<array>}>, settings?: array{_: 'themeSettings', base_theme: array, message_colors_animated: array, accent_color: array, outbox_accent_color: array, message_colors: list<array>, wallpaper?: array}}>}|array{_: 'webPageNotModified', cached_page_views: int}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_sizes: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int}, id: int, access_hash: int, short_name: string, title: string, description: string, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_thumbs: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: array, h: array}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array, mask: array, alt: array, mask_coords?: array}|array{_: 'documentAttributeVideo', round_message: array, supports_streaming: array, duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', voice: array, duration: array, title: array, performer: array, waveform: array}|array{_: 'documentAttributeFilename', file_name: array}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array, free: array, text_color: array, alt: array}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', duration: array}|array{_: 'documentAttributeSticker', stickerset: array, alt: array}|array{_: 'documentAttributeAudio', duration: array, title: array, performer: array}>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: string, access_hash: int, size: int, mime_type: string, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}|array{_: 'webDocumentNoProxy', url: string, size: int, mime_type: string, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}, receipt_msg_id: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w: int, h: int, thumb?: array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}, video_duration: int}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}, heading: int, period: int, proximity_notification_radius: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', id: int, closed: bool, public_voters: bool, multiple_choice: bool, quiz: bool, question: string, answers: list<array{_: 'pollAnswer', text: string, option: string}>, close_period: int, close_date: int}, results: array{_: 'pollResults', min: bool, results: list<array{_: 'pollAnswerVoters', chosen: bool, correct: bool, option: string, voters: int}>, total_voters: int, recent_voters: list<int>, solution: string, solution_entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>}}|array{_: 'messageMediaDice', value: int, emoticon: string}, reply_markup?: array, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>, views: int, forwards: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers: list<array|int|string>, channel_id: int, max_id: int, read_max_id: int}, edit_date: int, post_author: string, grouped_id: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, results: list<array{_: 'reactionCount', reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, chosen_order: int, count: int}>, recent_reactions: list<array{_: 'messagePeerReaction', peer_id: array|int|string, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, big: bool, unread: bool}>}, restriction_reason: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period: int}|array{_: 'messageService', peer_id: array|int|string, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', chat_id: array|int|string, title: string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name: string, phone: string, email: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', domain: string}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id: int}|array{_: 'messageActionTopicEdit', title: string, icon_emoji_id: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}}|array{_: 'messageActionAttachMenuBotAllowed'}|array{_: 'messageActionRequestedPeer', peer: array|int|string, button_id: int}, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, reply_to_msg_id: int, reply_to_peer_id?: array|int|string, reply_to_top_id: int}, date: int, ttl_period: int}>, chats: list<array|int|string>, users: list<array|int|string>}|array{_: 'messages.channelMessages', inexact: bool, pts: int, count: int, offset_id_offset: int, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, id: int, from_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, from_id?: array|int|string, from_name: string, date: int, channel_post: int, post_author: string, saved_from_peer?: array|int|string, saved_from_msg_id: int, psa_type: string}, via_bot_id: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, reply_to_msg_id: int, reply_to_peer_id?: array|int|string, reply_to_top_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}, ttl_seconds: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_thumbs: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}, ttl_seconds: int}|array{_: 'messageMediaWebPage', webpage: array{_: 'webPageEmpty', id: int}|array{_: 'webPagePending', id: int, date: int}|array{_: 'webPage', id: int, url: string, display_url: string, hash: int, type: string, site_name: string, title: string, description: string, photo?: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_sizes: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int}, embed_url: string, embed_type: string, embed_width: int, embed_height: int, duration: int, author: string, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_thumbs: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: array, h: array}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array, mask: array, alt: array, mask_coords?: array}|array{_: 'documentAttributeVideo', round_message: array, supports_streaming: array, duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', voice: array, duration: array, title: array, performer: array, waveform: array}|array{_: 'documentAttributeFilename', file_name: array}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array, free: array, text_color: array, alt: array}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', duration: array}|array{_: 'documentAttributeSticker', stickerset: array, alt: array}|array{_: 'documentAttributeAudio', duration: array, title: array, performer: array}>}, cached_page?: array{_: 'page', part: bool, rtl: bool, v2: bool, url: string, blocks: list<array{_: 'pageBlockUnsupported'}|array{_: 'pageBlockTitle', text: array}|array{_: 'pageBlockSubtitle', text: array}|array{_: 'pageBlockAuthorDate', author: array, published_date: array}|array{_: 'pageBlockHeader', text: array}|array{_: 'pageBlockSubheader', text: array}|array{_: 'pageBlockParagraph', text: array}|array{_: 'pageBlockPreformatted', text: array, language: array}|array{_: 'pageBlockFooter', text: array}|array{_: 'pageBlockDivider'}|array{_: 'pageBlockAnchor', name: array}|array{_: 'pageBlockList', items: list<array>}|array{_: 'pageBlockBlockquote', text: array, caption: array}|array{_: 'pageBlockPullquote', text: array, caption: array}|array{_: 'pageBlockPhoto', caption: array, photo_id: array, url: array, webpage_id: array}|array{_: 'pageBlockVideo', caption: array, autoplay: array, loop: array, video_id: array}|array{_: 'pageBlockCover', cover: array}|array{_: 'pageBlockEmbed', caption: array, full_width: array, allow_scrolling: array, url: array, html: array, poster_photo_id: array, w: array, h: array}|array{_: 'pageBlockChannel', channel: array}|array{_: 'pageBlockAudio', caption: array, audio_id: array}|array{_: 'pageBlockKicker', text: array}|array{_: 'pageBlockTable', title: array, bordered: array, striped: array, rows: list<array>}|array{_: 'pageBlockOrderedList', items: list<array>}|array{_: 'pageBlockRelatedArticles', title: array, articles: list<array>}|array{_: 'pageBlockMap', geo: array, caption: array, zoom: array, w: array, h: array}>, photos: list<array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes: list<array>, dc_id: array}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs: list<array>, video_thumbs: list<array>, dc_id: array, attributes: list<array>}>, views: int}, attributes: list<array{_: 'webPageAttributeTheme', documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs: list<array>, video_thumbs: list<array>, dc_id: array, attributes: list<array>}>, settings?: array{_: 'themeSettings', base_theme: array, message_colors_animated: array, accent_color: array, outbox_accent_color: array, message_colors: list<array>, wallpaper?: array}}>}|array{_: 'webPageNotModified', cached_page_views: int}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_sizes: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int}, id: int, access_hash: int, short_name: string, title: string, description: string, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_thumbs: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: array, h: array}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array, mask: array, alt: array, mask_coords?: array}|array{_: 'documentAttributeVideo', round_message: array, supports_streaming: array, duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', voice: array, duration: array, title: array, performer: array, waveform: array}|array{_: 'documentAttributeFilename', file_name: array}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array, free: array, text_color: array, alt: array}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', duration: array}|array{_: 'documentAttributeSticker', stickerset: array, alt: array}|array{_: 'documentAttributeAudio', duration: array, title: array, performer: array}>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: string, access_hash: int, size: int, mime_type: string, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}|array{_: 'webDocumentNoProxy', url: string, size: int, mime_type: string, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}, receipt_msg_id: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w: int, h: int, thumb?: array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}, video_duration: int}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}, heading: int, period: int, proximity_notification_radius: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', id: int, closed: bool, public_voters: bool, multiple_choice: bool, quiz: bool, question: string, answers: list<array{_: 'pollAnswer', text: string, option: string}>, close_period: int, close_date: int}, results: array{_: 'pollResults', min: bool, results: list<array{_: 'pollAnswerVoters', chosen: bool, correct: bool, option: string, voters: int}>, total_voters: int, recent_voters: list<int>, solution: string, solution_entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>}}|array{_: 'messageMediaDice', value: int, emoticon: string}, reply_markup?: array, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>, views: int, forwards: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers: list<array|int|string>, channel_id: int, max_id: int, read_max_id: int}, edit_date: int, post_author: string, grouped_id: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, results: list<array{_: 'reactionCount', reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, chosen_order: int, count: int}>, recent_reactions: list<array{_: 'messagePeerReaction', peer_id: array|int|string, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, big: bool, unread: bool}>}, restriction_reason: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period: int}|array{_: 'messageService', peer_id: array|int|string, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', chat_id: array|int|string, title: string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name: string, phone: string, email: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', domain: string}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id: int}|array{_: 'messageActionTopicEdit', title: string, icon_emoji_id: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}}|array{_: 'messageActionAttachMenuBotAllowed'}|array{_: 'messageActionRequestedPeer', peer: array|int|string, button_id: int}, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, reply_to_msg_id: int, reply_to_peer_id?: array|int|string, reply_to_top_id: int}, date: int, ttl_period: int}>, topics: list<array{_: 'forumTopicDeleted', id: int}|array{_: 'forumTopic', from_id: array|int|string, notify_settings: array{_: 'peerNotifySettings', show_previews?: bool, silent?: bool, mute_until: int, ios_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, android_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, other_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}}, my: bool, closed: bool, pinned: bool, short: bool, hidden: bool, id: int, date: int, title: string, icon_color: int, icon_emoji_id: int, top_message: int, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, unread_mentions_count: int, unread_reactions_count: int, draft?: array{_: 'draftMessageEmpty', date: int}|array{_: 'draftMessage', no_webpage: bool, reply_to_msg_id: int, message: string, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>, date: int}}>, chats: list<array|int|string>, users: list<array|int|string>}|array{_: 'messages.messagesNotModified', count: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.Messages.html
     */
    public function getMessagePublicForwards(array|int|string $channel, array|int|string $offset_peer, int $msg_id = 0, int $offset_rate = 0, int $offset_id = 0, int $limit = 0): array;

    /**
     * Get [message statistics](https://core.telegram.org/api/stats)
     *
     * @param array|int|string $channel Channel ID @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $dark Whether to enable dark theme for graph colors
     * @param int $msg_id Message ID
     * @return array{_: 'stats.messageStats', views_graph: array{_: 'statsGraphAsync', token: string}|array{_: 'statsGraphError', error: string}|array{_: 'statsGraph', json: mixed, zoom_token: string}} @see https://docs.madelineproto.xyz/API_docs/types/stats.MessageStats.html
     */
    public function getMessageStats(array|int|string $channel, bool $dark = false, int $msg_id = 0): array;
}
