<?php
/**
 * This file is automatic generated by build_docs.php file
 * and is used only for autocomplete in multiple IDE
 * don't modify manually.
 */

namespace danog\MadelineProto\Namespace;

interface Channels
{
    /**
     * Mark [channel/supergroup](https://core.telegram.org/api/channel) history as read
     *
     * @param array|int|string $channel [Channel/supergroup](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $max_id ID of message up to which messages should be marked as read
     * @return bool 
     */
    public function readHistory(array|int|string $channel, int $max_id = 0): bool;

    /**
     * Delete messages in a [channel/supergroup](https://core.telegram.org/api/channel)
     *
     * @param array|int|string $channel [Channel/supergroup](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param list<int>|array<never, never> $id IDs of messages to delete
     * @return array{_: 'messages.affectedMessages', pts: int, pts_count: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedMessages.html
     */
    public function deleteMessages(array|int|string $channel, array $id = []): array;

    /**
     * Reports some messages from a user in a supergroup as spam; requires administrator rights in the supergroup
     *
     * @param array|int|string $channel Supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $participant Participant whose messages should be reported @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param list<int>|array<never, never> $id IDs of spam messages
     * @return bool 
     */
    public function reportSpam(array|int|string $channel, array|int|string $participant, array $id = []): bool;

    /**
     * Get the participants of a [supergroup/channel](https://core.telegram.org/api/channel)
     *
     * @param array|int|string $channel Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array{_: 'channelParticipantsRecent'}|array{_: 'channelParticipantsAdmins'}|array{_: 'channelParticipantsKicked', q?: string}|array{_: 'channelParticipantsBots'}|array{_: 'channelParticipantsBanned', q?: string}|array{_: 'channelParticipantsSearch', q?: string}|array{_: 'channelParticipantsContacts', q?: string}|array{_: 'channelParticipantsMentions', q?: string, top_msg_id?: int} $filter Which participant types to fetch @see https://docs.madelineproto.xyz/API_docs/types/ChannelParticipantsFilter.html
     * @param int $offset [Offset](https://core.telegram.org/api/offsets)
     * @param int $limit [Limit](https://core.telegram.org/api/offsets)
     * @param list<int>|array<never, never> $hash [Hash](https://core.telegram.org/api/offsets)
     * @return array{_: 'channels.channelParticipants', count: int, participants: list<array{_: 'channelParticipant', user_id: int, date: int}|array{_: 'channelParticipantSelf', via_request: bool, user_id: int, inviter_id: int, date: int}|array{_: 'channelParticipantCreator', admin_rights: array{_: 'chatAdminRights', change_info: bool, post_messages: bool, edit_messages: bool, delete_messages: bool, ban_users: bool, invite_users: bool, pin_messages: bool, add_admins: bool, anonymous: bool, manage_call: bool, other: bool, manage_topics: bool}, user_id: int, rank: string}|array{_: 'channelParticipantAdmin', admin_rights: array{_: 'chatAdminRights', change_info: bool, post_messages: bool, edit_messages: bool, delete_messages: bool, ban_users: bool, invite_users: bool, pin_messages: bool, add_admins: bool, anonymous: bool, manage_call: bool, other: bool, manage_topics: bool}, can_edit: bool, self: bool, user_id: int, inviter_id: int, promoted_by: int, date: int, rank: string}|array{_: 'channelParticipantBanned', peer: array|int|string, banned_rights: array{_: 'chatBannedRights', view_messages: bool, send_messages: bool, send_media: bool, send_stickers: bool, send_gifs: bool, send_games: bool, send_inline: bool, embed_links: bool, send_polls: bool, change_info: bool, invite_users: bool, pin_messages: bool, manage_topics: bool, send_photos: bool, send_videos: bool, send_roundvideos: bool, send_audios: bool, send_voices: bool, send_docs: bool, send_plain: bool, until_date: int}, left: bool, kicked_by: int, date: int}|array{_: 'channelParticipantLeft', peer: array|int|string}>, chats: list<array|int|string>, users: list<array|int|string>}|array{_: 'channels.channelParticipantsNotModified'} @see https://docs.madelineproto.xyz/API_docs/types/channels.ChannelParticipants.html
     */
    public function getParticipants(array|int|string $channel, array $filter, int $offset = 0, int $limit = 0, array $hash = []): array;

    /**
     * Get info about a [channel/supergroup](https://core.telegram.org/api/channel) participant
     *
     * @param array|int|string $channel Channel/supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $participant Participant to get info about @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @return array{_: 'channels.channelParticipant', participant: array{_: 'channelParticipant', user_id: int, date: int}|array{_: 'channelParticipantSelf', via_request: bool, user_id: int, inviter_id: int, date: int}|array{_: 'channelParticipantCreator', admin_rights: array{_: 'chatAdminRights', change_info: bool, post_messages: bool, edit_messages: bool, delete_messages: bool, ban_users: bool, invite_users: bool, pin_messages: bool, add_admins: bool, anonymous: bool, manage_call: bool, other: bool, manage_topics: bool}, user_id: int, rank: string}|array{_: 'channelParticipantAdmin', admin_rights: array{_: 'chatAdminRights', change_info: bool, post_messages: bool, edit_messages: bool, delete_messages: bool, ban_users: bool, invite_users: bool, pin_messages: bool, add_admins: bool, anonymous: bool, manage_call: bool, other: bool, manage_topics: bool}, can_edit: bool, self: bool, user_id: int, inviter_id: int, promoted_by: int, date: int, rank: string}|array{_: 'channelParticipantBanned', peer: array|int|string, banned_rights: array{_: 'chatBannedRights', view_messages: bool, send_messages: bool, send_media: bool, send_stickers: bool, send_gifs: bool, send_games: bool, send_inline: bool, embed_links: bool, send_polls: bool, change_info: bool, invite_users: bool, pin_messages: bool, manage_topics: bool, send_photos: bool, send_videos: bool, send_roundvideos: bool, send_audios: bool, send_voices: bool, send_docs: bool, send_plain: bool, until_date: int}, left: bool, kicked_by: int, date: int}|array{_: 'channelParticipantLeft', peer: array|int|string}, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/channels.ChannelParticipant.html
     */
    public function getParticipant(array|int|string $channel, array|int|string $participant): array;

    /**
     * Create a [supergroup/channel](https://core.telegram.org/api/channel).
     *
     * @param bool $broadcast Whether to create a [channel](https://core.telegram.org/api/channel)
     * @param bool $megagroup Whether to create a [supergroup](https://core.telegram.org/api/channel)
     * @param bool $for_import Whether the supergroup is being created to import messages from a foreign chat service using [messages.initHistoryImport](https://docs.madelineproto.xyz/API_docs/methods/messages.initHistoryImport.html)
     * @param bool $forum 
     * @param string $title Channel title
     * @param string $about Channel description
     * @param array{_: 'inputGeoPointEmpty'}|array{_: 'inputGeoPoint', lat: float, long: float, accuracy_radius?: int}|array<never, never> $geo_point Geogroup location @see https://docs.madelineproto.xyz/API_docs/types/InputGeoPoint.html
     * @param string $address Geogroup address
     * @param int $ttl_period 
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function createChannel(bool $broadcast = false, bool $megagroup = false, bool $for_import = false, bool $forum = false, string $title = '', string $about = '', array $geo_point = [], string $address = '', int $ttl_period = 0): array;

    /**
     * Modify the admin rights of a user in a [supergroup/channel](https://core.telegram.org/api/channel).
     *
     * @param array|int|string $channel The [supergroup/channel](https://core.telegram.org/api/channel). @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $user_id The ID of the user whose admin rights should be modified @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param array{_: 'chatAdminRights', change_info?: bool, post_messages?: bool, edit_messages?: bool, delete_messages?: bool, ban_users?: bool, invite_users?: bool, pin_messages?: bool, add_admins?: bool, anonymous?: bool, manage_call?: bool, other?: bool, manage_topics?: bool} $admin_rights The admin rights @see https://docs.madelineproto.xyz/API_docs/types/ChatAdminRights.html
     * @param string $rank Indicates the role (rank) of the admin in the group: just an arbitrary string
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editAdmin(array|int|string $channel, array|int|string $user_id, array $admin_rights, string $rank = ''): array;

    /**
     * Edit the name of a [channel/supergroup](https://core.telegram.org/api/channel)
     *
     * @param array|int|string $channel Channel/supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param string $title New name
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editTitle(array|int|string $channel, string $title = ''): array;

    /**
     * Change the photo of a [channel/supergroup](https://core.telegram.org/api/channel)
     *
     * @param array|int|string $channel Channel/supergroup whose photo should be edited @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array{_: 'inputChatPhotoEmpty'}|array{_: 'inputChatUploadedPhoto', file?: mixed, video?: mixed, video_start_ts?: float, video_emoji_markup?: array{_: 'videoSize', type?: string, w?: int, h?: int, size?: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id?: int, background_colors?: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id?: int, access_hash?: int}|array{_: 'inputStickerSetShortName', short_name?: string}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon?: string}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id?: int, background_colors?: list<int>}}|array{_: 'inputChatPhoto', id: array} $photo New photo @see https://docs.madelineproto.xyz/API_docs/types/InputChatPhoto.html
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editPhoto(array|int|string $channel, array $photo): array;

    /**
     * Check if a username is free and can be assigned to a channel/supergroup
     *
     * @param array|int|string $channel The [channel/supergroup](https://core.telegram.org/api/channel) that will assigned the specified username @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param string $username The username to check
     * @return bool 
     */
    public function checkUsername(array|int|string $channel, string $username = ''): bool;

    /**
     * Change the username of a supergroup/channel
     *
     * @param array|int|string $channel Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param string $username New username
     * @return bool 
     */
    public function updateUsername(array|int|string $channel, string $username = ''): bool;

    /**
     * Join a channel/supergroup
     *
     * @param array|int|string $channel Channel/supergroup to join @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function joinChannel(array|int|string $channel): array;

    /**
     * Leave a [channel/supergroup](https://core.telegram.org/api/channel)
     *
     * @param array|int|string $channel [Channel/supergroup](https://core.telegram.org/api/channel) to leave @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function leaveChannel(array|int|string $channel): array;

    /**
     * Invite users to a channel/supergroup
     *
     * @param array|int|string $channel Channel/supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param list<array|int|string>|array<never, never> $users Array of Users to invite @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function inviteToChannel(array|int|string $channel, array $users = []): array;

    /**
     * Delete a [channel/supergroup](https://core.telegram.org/api/channel)
     *
     * @param array|int|string $channel [Channel/supergroup](https://core.telegram.org/api/channel) to delete @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function deleteChannel(array|int|string $channel): array;

    /**
     * Get link and embed info of a message in a [channel/supergroup](https://core.telegram.org/api/channel)
     *
     * @param array|int|string $channel Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $grouped Whether to include other grouped media (for albums)
     * @param bool $thread Whether to also include a thread ID, if available, inside of the link
     * @param int $id Message ID
     * @return array{_: 'exportedMessageLink', link: string, html: string} @see https://docs.madelineproto.xyz/API_docs/types/ExportedMessageLink.html
     */
    public function exportMessageLink(array|int|string $channel, bool $grouped = false, bool $thread = false, int $id = 0): array;

    /**
     * Enable/disable message signatures in channels
     *
     * @param array|int|string $channel Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $enabled Value
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleSignatures(array|int|string $channel, bool $enabled): array;

    /**
     * Get [channels/supergroups/geogroups](https://core.telegram.org/api/channel) we're admin in. Usually called when the user exceeds the [limit](https://docs.madelineproto.xyz/API_docs/constructors/config.html) for owned public [channels/supergroups/geogroups](https://core.telegram.org/api/channel), and the user is given the choice to remove one of his channels/supergroups/geogroups.
     *
     * @param bool $by_location Get geogroups
     * @param bool $check_limit If set and the user has reached the limit of owned public [channels/supergroups/geogroups](https://core.telegram.org/api/channel), instead of returning the channel list one of the specified [errors](#possible-errors) will be returned.<br>Useful to check if a new public channel can indeed be created, even before asking the user to enter a channel username to use in [channels.checkUsername](https://docs.madelineproto.xyz/API_docs/methods/channels.checkUsername.html)/[channels.updateUsername](https://docs.madelineproto.xyz/API_docs/methods/channels.updateUsername.html).
     * @return array{_: 'messages.chats', chats: list<array|int|string>}|array{_: 'messages.chatsSlice', count: int, chats: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Chats.html
     */
    public function getAdminedPublicChannels(bool $by_location = false, bool $check_limit = false): array;

    /**
     * Ban/unban/kick a user in a [supergroup/channel](https://core.telegram.org/api/channel).
     *
     * @param array|int|string $channel The [supergroup/channel](https://core.telegram.org/api/channel). @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $participant Participant to ban @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @param array{_: 'chatBannedRights', view_messages?: bool, send_messages?: bool, send_media?: bool, send_stickers?: bool, send_gifs?: bool, send_games?: bool, send_inline?: bool, embed_links?: bool, send_polls?: bool, change_info?: bool, invite_users?: bool, pin_messages?: bool, manage_topics?: bool, send_photos?: bool, send_videos?: bool, send_roundvideos?: bool, send_audios?: bool, send_voices?: bool, send_docs?: bool, send_plain?: bool, until_date?: int} $banned_rights The banned rights @see https://docs.madelineproto.xyz/API_docs/types/ChatBannedRights.html
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editBanned(array|int|string $channel, array|int|string $participant, array $banned_rights): array;

    /**
     * Get the admin log of a [channel/supergroup](https://core.telegram.org/api/channel)
     *
     * @param array|int|string $channel Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param string $q Search query, can be empty
     * @param array{_: 'channelAdminLogEventsFilter', join?: bool, leave?: bool, invite?: bool, ban?: bool, unban?: bool, kick?: bool, unkick?: bool, promote?: bool, demote?: bool, info?: bool, settings?: bool, pinned?: bool, edit?: bool, delete?: bool, group_call?: bool, invites?: bool, send?: bool, forums?: bool}|array<never, never> $events_filter Event filter @see https://docs.madelineproto.xyz/API_docs/types/ChannelAdminLogEventsFilter.html
     * @param list<array|int|string>|array<never, never> $admins Array of Only show events from these admins @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param int $max_id Maximum ID of message to return (see [pagination](https://core.telegram.org/api/offsets))
     * @param int $min_id Minimum ID of message to return (see [pagination](https://core.telegram.org/api/offsets))
     * @param int $limit Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * @return array{_: 'channels.adminLogResults', events: list<array{_: 'channelAdminLogEvent', action: array{_: 'channelAdminLogEventActionChangeTitle', prev_value: array, new_value: array}|array{_: 'channelAdminLogEventActionChangeAbout', prev_value: array, new_value: array}|array{_: 'channelAdminLogEventActionChangeUsername', prev_value: array, new_value: array}|array{_: 'channelAdminLogEventActionChangePhoto', prev_photo: array, new_photo: array}|array{_: 'channelAdminLogEventActionToggleInvites', new_value: array}|array{_: 'channelAdminLogEventActionToggleSignatures', new_value: array}|array{_: 'channelAdminLogEventActionUpdatePinned', message: array}|array{_: 'channelAdminLogEventActionEditMessage', prev_message: array, new_message: array}|array{_: 'channelAdminLogEventActionDeleteMessage', message: array}|array{_: 'channelAdminLogEventActionParticipantJoin'}|array{_: 'channelAdminLogEventActionParticipantLeave'}|array{_: 'channelAdminLogEventActionParticipantInvite', participant: array}|array{_: 'channelAdminLogEventActionParticipantToggleBan', prev_participant: array, new_participant: array}|array{_: 'channelAdminLogEventActionParticipantToggleAdmin', prev_participant: array, new_participant: array}|array{_: 'channelAdminLogEventActionChangeStickerSet', prev_stickerset: array, new_stickerset: array}|array{_: 'channelAdminLogEventActionTogglePreHistoryHidden', new_value: array}|array{_: 'channelAdminLogEventActionDefaultBannedRights', prev_banned_rights: array, new_banned_rights: array}|array{_: 'channelAdminLogEventActionStopPoll', message: array}|array{_: 'channelAdminLogEventActionChangeLinkedChat', prev_value: array, new_value: array}|array{_: 'channelAdminLogEventActionChangeLocation', prev_value: array, new_value: array}|array{_: 'channelAdminLogEventActionToggleSlowMode', prev_value: array, new_value: array}|array{_: 'channelAdminLogEventActionStartGroupCall', call: array}|array{_: 'channelAdminLogEventActionDiscardGroupCall', call: array}|array{_: 'channelAdminLogEventActionParticipantMute', participant: array}|array{_: 'channelAdminLogEventActionParticipantUnmute', participant: array}|array{_: 'channelAdminLogEventActionToggleGroupCallSetting', join_muted: array}|array{_: 'channelAdminLogEventActionParticipantJoinByInvite', invite: array}|array{_: 'channelAdminLogEventActionExportedInviteDelete', invite: array}|array{_: 'channelAdminLogEventActionExportedInviteRevoke', invite: array}|array{_: 'channelAdminLogEventActionExportedInviteEdit', prev_invite: array, new_invite: array}|array{_: 'channelAdminLogEventActionParticipantVolume', participant: array}|array{_: 'channelAdminLogEventActionChangeHistoryTTL', prev_value: array, new_value: array}|array{_: 'channelAdminLogEventActionParticipantJoinByRequest', invite: array, approved_by: array}|array{_: 'channelAdminLogEventActionToggleNoForwards', new_value: array}|array{_: 'channelAdminLogEventActionSendMessage', message: array}|array{_: 'channelAdminLogEventActionChangeAvailableReactions', prev_value: array, new_value: array}|array{_: 'channelAdminLogEventActionChangeUsernames', prev_value: list<array>, new_value: list<array>}|array{_: 'channelAdminLogEventActionToggleForum', new_value: array}|array{_: 'channelAdminLogEventActionCreateTopic', topic: array}|array{_: 'channelAdminLogEventActionEditTopic', prev_topic: array, new_topic: array}|array{_: 'channelAdminLogEventActionDeleteTopic', topic: array}|array{_: 'channelAdminLogEventActionPinTopic', prev_topic?: array, new_topic?: array}|array{_: 'channelAdminLogEventActionToggleAntiSpam', new_value: array}, id: int, date: int, user_id: int}>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/channels.AdminLogResults.html
     */
    public function getAdminLog(array|int|string $channel, string $q = '', array $events_filter = [], array $admins = [], int $max_id = 0, int $min_id = 0, int $limit = 0): array;

    /**
     * Associate a stickerset to the supergroup
     *
     * @param array|int|string $channel Supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id?: int, access_hash?: int}|array{_: 'inputStickerSetShortName', short_name?: string}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon?: string}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'} $stickerset The stickerset to associate @see https://docs.madelineproto.xyz/API_docs/types/InputStickerSet.html
     * @return bool 
     */
    public function setStickers(array|int|string $channel, array $stickerset): bool;

    /**
     * Mark [channel/supergroup](https://core.telegram.org/api/channel) message contents as read
     *
     * @param array|int|string $channel [Channel/supergroup](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param list<int>|array<never, never> $id IDs of messages whose contents should be marked as read
     * @return bool 
     */
    public function readMessageContents(array|int|string $channel, array $id = []): bool;

    /**
     * Delete the history of a [supergroup](https://core.telegram.org/api/channel)
     *
     * @param array|int|string $channel [Supergroup](https://core.telegram.org/api/channel) whose history must be deleted @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $for_everyone Whether the history should be deleted for everyone
     * @param int $max_id ID of message **up to which** the history must be deleted
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function deleteHistory(array|int|string $channel, bool $for_everyone = false, int $max_id = 0): array;

    /**
     * Hide/unhide message history for new channel/supergroup users
     *
     * @param array|int|string $channel Channel/supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $enabled Hide/unhide
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function togglePreHistoryHidden(array|int|string $channel, bool $enabled): array;

    /**
     * Get a list of [channels/supergroups](https://core.telegram.org/api/channel) we left
     *
     * @param int $offset Offset for [pagination](https://core.telegram.org/api/offsets)
     * @return array{_: 'messages.chats', chats: list<array|int|string>}|array{_: 'messages.chatsSlice', count: int, chats: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Chats.html
     */
    public function getLeftChannels(int $offset = 0): array;

    /**
     * Get all groups that can be used as [discussion groups](https://core.telegram.org/api/discussion).
     * 
     * Returned [basic group chats](https://core.telegram.org/api/channel#basic-groups) must be first upgraded to [supergroups](https://core.telegram.org/api/channel#supergroups) before they can be set as a discussion group.  
     * To set a returned supergroup as a discussion group, access to its old messages must be enabled using [channels.togglePreHistoryHidden](https://docs.madelineproto.xyz/API_docs/methods/channels.togglePreHistoryHidden.html), first.
     *
     * @return array{_: 'messages.chats', chats: list<array|int|string>}|array{_: 'messages.chatsSlice', count: int, chats: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.Chats.html
     */
    public function getGroupsForDiscussion(): array;

    /**
     * Associate a group to a channel as [discussion group](https://core.telegram.org/api/discussion) for that channel
     *
     * @param array|int|string $broadcast Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $group [Discussion group](https://core.telegram.org/api/discussion) to associate to the channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @return bool 
     */
    public function setDiscussionGroup(array|int|string $broadcast, array|int|string $group): bool;

    /**
     * Transfer channel ownership
     *
     * @param array|int|string $channel Channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $user_id New channel owner @see https://docs.madelineproto.xyz/API_docs/types/InputUser.html
     * @param array{_: 'inputCheckPasswordEmpty'}|array{_: 'inputCheckPasswordSRP', srp_id?: int, A?: string, M1?: string} $password [2FA password](https://core.telegram.org/api/srp) of account @see https://docs.madelineproto.xyz/API_docs/types/InputCheckPasswordSRP.html
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editCreator(array|int|string $channel, array|int|string $user_id, array $password): array;

    /**
     * Edit location of geogroup
     *
     * @param array|int|string $channel [Geogroup](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array{_: 'inputGeoPointEmpty'}|array{_: 'inputGeoPoint', lat: float, long: float, accuracy_radius?: int} $geo_point New geolocation @see https://docs.madelineproto.xyz/API_docs/types/InputGeoPoint.html
     * @param string $address Address string
     * @return bool 
     */
    public function editLocation(array|int|string $channel, array $geo_point, string $address = ''): bool;

    /**
     * Toggle supergroup slow mode: if enabled, users will only be able to send one message every `seconds` seconds
     *
     * @param array|int|string $channel The [supergroup](https://core.telegram.org/api/channel) @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $seconds Users will only be able to send one message every `seconds` seconds, `0` to disable the limitation
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleSlowMode(array|int|string $channel, int $seconds = 0): array;

    /**
     * Get inactive channels and supergroups
     *
     * @return array{_: 'messages.inactiveChats', dates: list<int>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/messages.InactiveChats.html
     */
    public function getInactiveChannels(): array;

    /**
     * Convert a [supergroup](https://core.telegram.org/api/channel) to a [gigagroup](https://core.telegram.org/api/channel), when requested by [channel suggestions](https://core.telegram.org/api/config#channel-suggestions).
     *
     * @param array|int|string $channel The [supergroup](https://core.telegram.org/api/channel) to convert @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function convertToGigagroup(array|int|string $channel): array;

    /**
     * Mark a specific sponsored message as read
     *
     * @param array|int|string $channel Peer @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @return bool 
     */
    public function viewSponsoredMessage(array|int|string $channel): bool;

    /**
     * Get a list of sponsored messages
     *
     * @param array|int|string $channel Peer @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @return array{_: 'messages.sponsoredMessages', posts_between: int, messages: list<array{_: 'sponsoredMessage', recommended: bool, show_peer_photo: bool, from_id?: array|int|string, chat_invite?: array{_: 'chatInviteAlready', chat: array|int|string}|array{_: 'chatInvite', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}, channel: bool, broadcast: bool, public: bool, megagroup: bool, request_needed: bool, title: string, about: string, participants_count: int, participants: list<array|int|string>}|array{_: 'chatInvitePeek', chat: array|int|string, expires: int}, chat_invite_hash: string, channel_post: int, start_param: string, message: string, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>}>, chats: list<array|int|string>, users: list<array|int|string>}|array{_: 'messages.sponsoredMessagesEmpty'} @see https://docs.madelineproto.xyz/API_docs/types/messages.SponsoredMessages.html
     */
    public function getSponsoredMessages(array|int|string $channel): array;

    /**
     * Obtains a list of peers that can be used to send messages in a specific group
     *
     * @param array|int|string $peer The group where we intend to send messages @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @return array{_: 'channels.sendAsPeers', peers: list<array{_: 'sendAsPeer', peer: array|int|string, premium_required: bool}>, chats: list<array|int|string>, users: list<array|int|string>} @see https://docs.madelineproto.xyz/API_docs/types/channels.SendAsPeers.html
     */
    public function getSendAs(array|int|string $peer): array;

    /**
     * Delete all messages sent by a specific participant of a given supergroup
     *
     * @param array|int|string $channel Supergroup @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param array|int|string $participant The participant whose messages should be deleted @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @return array{_: 'messages.affectedHistory', pts: int, pts_count: int, offset: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedHistory.html
     */
    public function deleteParticipantHistory(array|int|string $channel, array|int|string $participant): array;

    /**
     * Set whether all users [should join a discussion group in order to comment on a post »](https://core.telegram.org/api/discussion#requiring-users-to-join-the-group)
     *
     * @param array|int|string $channel Discussion group @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $enabled Toggle
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleJoinToSend(array|int|string $channel, bool $enabled): array;

    /**
     * Set whether all users should [request admin approval to join the group »](https://core.telegram.org/api/invites#join-requests).
     *
     * @param array|int|string $channel Group @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $enabled Toggle
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleJoinRequest(array|int|string $channel, bool $enabled): array;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param list<string>|array<never, never> $order 
     * @return bool 
     */
    public function reorderUsernames(array|int|string $channel, array $order = []): bool;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $active 
     * @param string $username 
     * @return bool 
     */
    public function toggleUsername(array|int|string $channel, bool $active, string $username = ''): bool;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @return bool 
     */
    public function deactivateAllUsernames(array|int|string $channel): bool;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $enabled 
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleForum(array|int|string $channel, bool $enabled): array;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param string $title 
     * @param int $icon_color 
     * @param int $icon_emoji_id 
     * @param array|int|string $send_as @see https://docs.madelineproto.xyz/API_docs/types/InputPeer.html
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function createForumTopic(array|int|string $channel, string $title = '', int $icon_color = 0, int $icon_emoji_id = 0, array|int|string $send_as = []): array;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param string $q 
     * @param int $offset_date 
     * @param int $offset_id 
     * @param int $offset_topic 
     * @param int $limit 
     * @return array{_: 'messages.forumTopics', order_by_create_date: bool, count: int, topics: list<array{_: 'forumTopicDeleted', id: int}|array{_: 'forumTopic', from_id: array|int|string, notify_settings: array{_: 'peerNotifySettings', show_previews?: bool, silent?: bool, mute_until: int, ios_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, android_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, other_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}}, my: bool, closed: bool, pinned: bool, short: bool, hidden: bool, id: int, date: int, title: string, icon_color: int, icon_emoji_id: int, top_message: int, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, unread_mentions_count: int, unread_reactions_count: int, draft?: array{_: 'draftMessageEmpty', date: int}|array{_: 'draftMessage', no_webpage: bool, reply_to_msg_id: int, message: string, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>, date: int}}>, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, id: int, from_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, from_id?: array|int|string, from_name: string, date: int, channel_post: int, post_author: string, saved_from_peer?: array|int|string, saved_from_msg_id: int, psa_type: string}, via_bot_id: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, reply_to_msg_id: int, reply_to_peer_id?: array|int|string, reply_to_top_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}, ttl_seconds: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_thumbs: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}, ttl_seconds: int}|array{_: 'messageMediaWebPage', webpage: array{_: 'webPageEmpty', id: int}|array{_: 'webPagePending', id: int, date: int}|array{_: 'webPage', id: int, url: string, display_url: string, hash: int, type: string, site_name: string, title: string, description: string, photo?: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_sizes: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int}, embed_url: string, embed_type: string, embed_width: int, embed_height: int, duration: int, author: string, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_thumbs: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: array, h: array}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array, mask: array, alt: array, mask_coords?: array}|array{_: 'documentAttributeVideo', round_message: array, supports_streaming: array, duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', voice: array, duration: array, title: array, performer: array, waveform: array}|array{_: 'documentAttributeFilename', file_name: array}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array, free: array, text_color: array, alt: array}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', duration: array}|array{_: 'documentAttributeSticker', stickerset: array, alt: array}|array{_: 'documentAttributeAudio', duration: array, title: array, performer: array}>}, cached_page?: array{_: 'page', part: bool, rtl: bool, v2: bool, url: string, blocks: list<array{_: 'pageBlockUnsupported'}|array{_: 'pageBlockTitle', text: array}|array{_: 'pageBlockSubtitle', text: array}|array{_: 'pageBlockAuthorDate', author: array, published_date: array}|array{_: 'pageBlockHeader', text: array}|array{_: 'pageBlockSubheader', text: array}|array{_: 'pageBlockParagraph', text: array}|array{_: 'pageBlockPreformatted', text: array, language: array}|array{_: 'pageBlockFooter', text: array}|array{_: 'pageBlockDivider'}|array{_: 'pageBlockAnchor', name: array}|array{_: 'pageBlockList', items: list<array>}|array{_: 'pageBlockBlockquote', text: array, caption: array}|array{_: 'pageBlockPullquote', text: array, caption: array}|array{_: 'pageBlockPhoto', caption: array, photo_id: array, url: array, webpage_id: array}|array{_: 'pageBlockVideo', caption: array, autoplay: array, loop: array, video_id: array}|array{_: 'pageBlockCover', cover: array}|array{_: 'pageBlockEmbed', caption: array, full_width: array, allow_scrolling: array, url: array, html: array, poster_photo_id: array, w: array, h: array}|array{_: 'pageBlockChannel', channel: array}|array{_: 'pageBlockAudio', caption: array, audio_id: array}|array{_: 'pageBlockKicker', text: array}|array{_: 'pageBlockTable', title: array, bordered: array, striped: array, rows: list<array>}|array{_: 'pageBlockOrderedList', items: list<array>}|array{_: 'pageBlockRelatedArticles', title: array, articles: list<array>}|array{_: 'pageBlockMap', geo: array, caption: array, zoom: array, w: array, h: array}>, photos: list<array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes: list<array>, dc_id: array}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs: list<array>, video_thumbs: list<array>, dc_id: array, attributes: list<array>}>, views: int}, attributes: list<array{_: 'webPageAttributeTheme', documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs: list<array>, video_thumbs: list<array>, dc_id: array, attributes: list<array>}>, settings?: array{_: 'themeSettings', base_theme: array, message_colors_animated: array, accent_color: array, outbox_accent_color: array, message_colors: list<array>, wallpaper?: array}}>}|array{_: 'webPageNotModified', cached_page_views: int}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_sizes: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int}, id: int, access_hash: int, short_name: string, title: string, description: string, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_thumbs: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: array, h: array}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array, mask: array, alt: array, mask_coords?: array}|array{_: 'documentAttributeVideo', round_message: array, supports_streaming: array, duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', voice: array, duration: array, title: array, performer: array, waveform: array}|array{_: 'documentAttributeFilename', file_name: array}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array, free: array, text_color: array, alt: array}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', duration: array}|array{_: 'documentAttributeSticker', stickerset: array, alt: array}|array{_: 'documentAttributeAudio', duration: array, title: array, performer: array}>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: string, access_hash: int, size: int, mime_type: string, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}|array{_: 'webDocumentNoProxy', url: string, size: int, mime_type: string, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}, receipt_msg_id: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w: int, h: int, thumb?: array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}, video_duration: int}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}, heading: int, period: int, proximity_notification_radius: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', id: int, closed: bool, public_voters: bool, multiple_choice: bool, quiz: bool, question: string, answers: list<array{_: 'pollAnswer', text: string, option: string}>, close_period: int, close_date: int}, results: array{_: 'pollResults', min: bool, results: list<array{_: 'pollAnswerVoters', chosen: bool, correct: bool, option: string, voters: int}>, total_voters: int, recent_voters: list<int>, solution: string, solution_entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>}}|array{_: 'messageMediaDice', value: int, emoticon: string}, reply_markup?: array, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>, views: int, forwards: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers: list<array|int|string>, channel_id: int, max_id: int, read_max_id: int}, edit_date: int, post_author: string, grouped_id: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, results: list<array{_: 'reactionCount', reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, chosen_order: int, count: int}>, recent_reactions: list<array{_: 'messagePeerReaction', peer_id: array|int|string, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, big: bool, unread: bool}>}, restriction_reason: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period: int}|array{_: 'messageService', peer_id: array|int|string, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', chat_id: array|int|string, title: string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name: string, phone: string, email: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', domain: string}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id: int}|array{_: 'messageActionTopicEdit', title: string, icon_emoji_id: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}}|array{_: 'messageActionAttachMenuBotAllowed'}|array{_: 'messageActionRequestedPeer', peer: array|int|string, button_id: int}, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, reply_to_msg_id: int, reply_to_peer_id?: array|int|string, reply_to_top_id: int}, date: int, ttl_period: int}>, chats: list<array|int|string>, users: list<array|int|string>, pts: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.ForumTopics.html
     */
    public function getForumTopics(array|int|string $channel, string $q = '', int $offset_date = 0, int $offset_id = 0, int $offset_topic = 0, int $limit = 0): array;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param list<int>|array<never, never> $topics 
     * @return array{_: 'messages.forumTopics', order_by_create_date: bool, count: int, topics: list<array{_: 'forumTopicDeleted', id: int}|array{_: 'forumTopic', from_id: array|int|string, notify_settings: array{_: 'peerNotifySettings', show_previews?: bool, silent?: bool, mute_until: int, ios_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, android_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}, other_sound?: array{_: 'notificationSoundDefault'}|array{_: 'notificationSoundNone'}|array{_: 'notificationSoundLocal', title: string, data: string}|array{_: 'notificationSoundRingtone', id: int}}, my: bool, closed: bool, pinned: bool, short: bool, hidden: bool, id: int, date: int, title: string, icon_color: int, icon_emoji_id: int, top_message: int, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, unread_mentions_count: int, unread_reactions_count: int, draft?: array{_: 'draftMessageEmpty', date: int}|array{_: 'draftMessage', no_webpage: bool, reply_to_msg_id: int, message: string, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>, date: int}}>, messages: list<array{_: 'messageEmpty', id: int, peer_id?: array|int|string}|array{_: 'message', peer_id: array|int|string, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, from_scheduled: bool, legacy: bool, edit_hide: bool, pinned: bool, noforwards: bool, id: int, from_id?: array|int|string, fwd_from?: array{_: 'messageFwdHeader', imported: bool, from_id?: array|int|string, from_name: string, date: int, channel_post: int, post_author: string, saved_from_peer?: array|int|string, saved_from_msg_id: int, psa_type: string}, via_bot_id: int, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, reply_to_msg_id: int, reply_to_peer_id?: array|int|string, reply_to_top_id: int}, date: int, message: string, media?: array{_: 'messageMediaEmpty'}|array{_: 'messageMediaPhoto', spoiler: bool, photo?: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}, ttl_seconds: int}|array{_: 'messageMediaGeo', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}}|array{_: 'messageMediaContact', phone_number: string, first_name: string, last_name: string, vcard: string, user_id: int}|array{_: 'messageMediaUnsupported'}|array{_: 'messageMediaDocument', nopremium: bool, spoiler: bool, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_thumbs: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}, ttl_seconds: int}|array{_: 'messageMediaWebPage', webpage: array{_: 'webPageEmpty', id: int}|array{_: 'webPagePending', id: int, date: int}|array{_: 'webPage', id: int, url: string, display_url: string, hash: int, type: string, site_name: string, title: string, description: string, photo?: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_sizes: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int}, embed_url: string, embed_type: string, embed_width: int, embed_height: int, duration: int, author: string, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_thumbs: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: array, h: array}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array, mask: array, alt: array, mask_coords?: array}|array{_: 'documentAttributeVideo', round_message: array, supports_streaming: array, duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', voice: array, duration: array, title: array, performer: array, waveform: array}|array{_: 'documentAttributeFilename', file_name: array}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array, free: array, text_color: array, alt: array}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', duration: array}|array{_: 'documentAttributeSticker', stickerset: array, alt: array}|array{_: 'documentAttributeAudio', duration: array, title: array, performer: array}>}, cached_page?: array{_: 'page', part: bool, rtl: bool, v2: bool, url: string, blocks: list<array{_: 'pageBlockUnsupported'}|array{_: 'pageBlockTitle', text: array}|array{_: 'pageBlockSubtitle', text: array}|array{_: 'pageBlockAuthorDate', author: array, published_date: array}|array{_: 'pageBlockHeader', text: array}|array{_: 'pageBlockSubheader', text: array}|array{_: 'pageBlockParagraph', text: array}|array{_: 'pageBlockPreformatted', text: array, language: array}|array{_: 'pageBlockFooter', text: array}|array{_: 'pageBlockDivider'}|array{_: 'pageBlockAnchor', name: array}|array{_: 'pageBlockList', items: list<array>}|array{_: 'pageBlockBlockquote', text: array, caption: array}|array{_: 'pageBlockPullquote', text: array, caption: array}|array{_: 'pageBlockPhoto', caption: array, photo_id: array, url: array, webpage_id: array}|array{_: 'pageBlockVideo', caption: array, autoplay: array, loop: array, video_id: array}|array{_: 'pageBlockCover', cover: array}|array{_: 'pageBlockEmbed', caption: array, full_width: array, allow_scrolling: array, url: array, html: array, poster_photo_id: array, w: array, h: array}|array{_: 'pageBlockChannel', channel: array}|array{_: 'pageBlockAudio', caption: array, audio_id: array}|array{_: 'pageBlockKicker', text: array}|array{_: 'pageBlockTable', title: array, bordered: array, striped: array, rows: list<array>}|array{_: 'pageBlockOrderedList', items: list<array>}|array{_: 'pageBlockRelatedArticles', title: array, articles: list<array>}|array{_: 'pageBlockMap', geo: array, caption: array, zoom: array, w: array, h: array}>, photos: list<array{_: 'photoEmpty', id: array}|array{_: 'photo', has_stickers: array, id: array, access_hash: array, file_reference: array, date: array, sizes: list<array>, video_sizes: list<array>, dc_id: array}>, documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs: list<array>, video_thumbs: list<array>, dc_id: array, attributes: list<array>}>, views: int}, attributes: list<array{_: 'webPageAttributeTheme', documents: list<array{_: 'documentEmpty', id: array}|array{_: 'document', id: array, access_hash: array, file_reference: array, date: array, mime_type: array, size: array, thumbs: list<array>, video_thumbs: list<array>, dc_id: array, attributes: list<array>}>, settings?: array{_: 'themeSettings', base_theme: array, message_colors_animated: array, accent_color: array, outbox_accent_color: array, message_colors: list<array>, wallpaper?: array}}>}|array{_: 'webPageNotModified', cached_page_views: int}}|array{_: 'messageMediaVenue', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}, title: string, address: string, provider: string, venue_id: string, venue_type: string}|array{_: 'messageMediaGame', game: array{_: 'game', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_sizes: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int}, id: int, access_hash: int, short_name: string, title: string, description: string, document?: array{_: 'documentEmpty', id: int}|array{_: 'document', id: int, access_hash: int, file_reference: string, date: int, mime_type: string, size: int, thumbs: list<array{_: 'photoSizeEmpty', type: array}|array{_: 'photoSize', type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', type: array, w: array, h: array, bytes: array}|array{_: 'photoStrippedSize', type: array, bytes: array}|array{_: 'photoSizeProgressive', type: array, w: array, h: array, sizes: list<array>}|array{_: 'photoPathSize', type: array, bytes: array}|array{_: 'photoSize', location: array, type: array, w: array, h: array, size: array}|array{_: 'photoCachedSize', location: array, type: array, w: array, h: array, bytes: array}>, video_thumbs: list<array{_: 'videoSize', type: array, w: array, h: array, size: array, video_start_ts?: array}|array{_: 'videoSizeEmojiMarkup', emoji_id: array, background_colors: list<array>}|array{_: 'videoSizeStickerMarkup', stickerset: array, sticker_id: array, background_colors: list<array>}>, dc_id: int, attributes: list<array{_: 'documentAttributeImageSize', w: array, h: array}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array, mask: array, alt: array, mask_coords?: array}|array{_: 'documentAttributeVideo', round_message: array, supports_streaming: array, duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', voice: array, duration: array, title: array, performer: array, waveform: array}|array{_: 'documentAttributeFilename', file_name: array}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array, free: array, text_color: array, alt: array}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: array, w: array, h: array}|array{_: 'documentAttributeAudio', duration: array}|array{_: 'documentAttributeSticker', stickerset: array, alt: array}|array{_: 'documentAttributeAudio', duration: array, title: array, performer: array}>}}}|array{_: 'messageMediaInvoice', shipping_address_requested: bool, test: bool, title: string, description: string, photo?: array{_: 'webDocument', url: string, access_hash: int, size: int, mime_type: string, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}|array{_: 'webDocumentNoProxy', url: string, size: int, mime_type: string, attributes: list<array{_: 'documentAttributeImageSize', w: int, h: int}|array{_: 'documentAttributeAnimated'}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, mask: bool, alt: string, mask_coords?: array{_: 'maskCoords', x: array, y: array, zoom: array, n: array}}|array{_: 'documentAttributeVideo', round_message: bool, supports_streaming: bool, duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', voice: bool, duration: int, title: string, performer: string, waveform: string}|array{_: 'documentAttributeFilename', file_name: string}|array{_: 'documentAttributeHasStickers'}|array{_: 'documentAttributeCustomEmoji', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, free: bool, text_color: bool, alt: string}|array{_: 'documentAttributeSticker'}|array{_: 'documentAttributeVideo', duration: int, w: int, h: int}|array{_: 'documentAttributeAudio', duration: int}|array{_: 'documentAttributeSticker', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, alt: string}|array{_: 'documentAttributeAudio', duration: int, title: string, performer: string}>}, receipt_msg_id: int, currency: string, total_amount: int, start_param: string, extended_media?: array{_: 'messageExtendedMediaPreview', w: int, h: int, thumb?: array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}, video_duration: int}}|array{_: 'messageMediaGeoLive', geo: array{_: 'geoPointEmpty'}|array{_: 'geoPoint', long: float, lat: float, access_hash: int, accuracy_radius: int}, heading: int, period: int, proximity_notification_radius: int}|array{_: 'messageMediaPoll', poll: array{_: 'poll', id: int, closed: bool, public_voters: bool, multiple_choice: bool, quiz: bool, question: string, answers: list<array{_: 'pollAnswer', text: string, option: string}>, close_period: int, close_date: int}, results: array{_: 'pollResults', min: bool, results: list<array{_: 'pollAnswerVoters', chosen: bool, correct: bool, option: string, voters: int}>, total_voters: int, recent_voters: list<int>, solution: string, solution_entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>}}|array{_: 'messageMediaDice', value: int, emoticon: string}, reply_markup?: array, entities: list<array{_: 'messageEntityUnknown', offset: int, length: int}|array{_: 'messageEntityMention', offset: int, length: int}|array{_: 'messageEntityHashtag', offset: int, length: int}|array{_: 'messageEntityBotCommand', offset: int, length: int}|array{_: 'messageEntityUrl', offset: int, length: int}|array{_: 'messageEntityEmail', offset: int, length: int}|array{_: 'messageEntityBold', offset: int, length: int}|array{_: 'messageEntityItalic', offset: int, length: int}|array{_: 'messageEntityCode', offset: int, length: int}|array{_: 'messageEntityPre', offset: int, length: int, language: string}|array{_: 'messageEntityTextUrl', offset: int, length: int, url: string}|array{_: 'messageEntityMentionName', offset: int, length: int, user_id: int}|array{_: 'inputMessageEntityMentionName', user_id: array|int|string, offset: int, length: int}|array{_: 'messageEntityPhone', offset: int, length: int}|array{_: 'messageEntityCashtag', offset: int, length: int}|array{_: 'messageEntityUnderline', offset: int, length: int}|array{_: 'messageEntityStrike', offset: int, length: int}|array{_: 'messageEntityBlockquote', offset: int, length: int}|array{_: 'messageEntityBankCard', offset: int, length: int}|array{_: 'messageEntitySpoiler', offset: int, length: int}|array{_: 'messageEntityCustomEmoji', offset: int, length: int, document_id: int}>, views: int, forwards: int, replies?: array{_: 'messageReplies', comments: bool, replies: int, replies_pts: int, recent_repliers: list<array|int|string>, channel_id: int, max_id: int, read_max_id: int}, edit_date: int, post_author: string, grouped_id: int, reactions?: array{_: 'messageReactions', min: bool, can_see_list: bool, results: list<array{_: 'reactionCount', reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, chosen_order: int, count: int}>, recent_reactions: list<array{_: 'messagePeerReaction', peer_id: array|int|string, reaction: array{_: 'reactionEmpty'}|array{_: 'reactionEmoji', emoticon: string}|array{_: 'reactionCustomEmoji', document_id: int}, big: bool, unread: bool}>}, restriction_reason: list<array{_: 'restrictionReason', platform: string, reason: string, text: string}>, ttl_period: int}|array{_: 'messageService', peer_id: array|int|string, action: array{_: 'messageActionEmpty'}|array{_: 'messageActionChatCreate', title: string, users: list<int>}|array{_: 'messageActionChatEditTitle', title: string}|array{_: 'messageActionChatEditPhoto', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}}|array{_: 'messageActionChatDeletePhoto'}|array{_: 'messageActionChatAddUser', users: list<int>}|array{_: 'messageActionChatDeleteUser', user_id: int}|array{_: 'messageActionChatJoinedByLink', inviter_id: int}|array{_: 'messageActionChannelCreate', title: string}|array{_: 'messageActionChatMigrateTo', channel_id: int}|array{_: 'messageActionChannelMigrateFrom', chat_id: array|int|string, title: string}|array{_: 'messageActionPinMessage'}|array{_: 'messageActionHistoryClear'}|array{_: 'messageActionGameScore', game_id: int, score: int}|array{_: 'messageActionPaymentSentMe', charge: array{_: 'paymentCharge', id: string, provider_charge_id: string}, recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, payload: string, info?: array{_: 'paymentRequestedInfo', name: string, phone: string, email: string, shipping_address?: array{_: 'postAddress', street_line1: string, street_line2: string, city: string, state: string, country_iso2: string, post_code: string}}, shipping_option_id: string}|array{_: 'messageActionPaymentSent', recurring_init: bool, recurring_used: bool, currency: string, total_amount: int, invoice_slug: string}|array{_: 'messageActionPhoneCall', video: bool, call_id: int, reason?: array{_: 'phoneCallDiscardReasonMissed'}|array{_: 'phoneCallDiscardReasonDisconnect'}|array{_: 'phoneCallDiscardReasonHangup'}|array{_: 'phoneCallDiscardReasonBusy'}, duration: int}|array{_: 'messageActionScreenshotTaken'}|array{_: 'messageActionCustomAction', message: string}|array{_: 'messageActionBotAllowed', domain: string}|array{_: 'messageActionSecureValuesSentMe', credentials: array{_: 'secureCredentialsEncrypted', data: string, hash: string, secret: string}, values: list<array{_: 'secureValue', type: array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}, data?: array{_: 'secureData', data: string, data_hash: string, secret: string}, front_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, reverse_side?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, selfie?: array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}, translation: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, files: list<array{_: 'secureFileEmpty'}|array{_: 'secureFile', id: int, access_hash: int, size: int, dc_id: int, date: int, file_hash: string, secret: string}>, plain_data?: array{_: 'securePlainPhone', phone: string}|array{_: 'securePlainEmail', email: string}, hash: string}>}|array{_: 'messageActionSecureValuesSent', types: list<array{_: 'secureValueTypePersonalDetails'}|array{_: 'secureValueTypePassport'}|array{_: 'secureValueTypeDriverLicense'}|array{_: 'secureValueTypeIdentityCard'}|array{_: 'secureValueTypeInternalPassport'}|array{_: 'secureValueTypeAddress'}|array{_: 'secureValueTypeUtilityBill'}|array{_: 'secureValueTypeBankStatement'}|array{_: 'secureValueTypeRentalAgreement'}|array{_: 'secureValueTypePassportRegistration'}|array{_: 'secureValueTypeTemporaryRegistration'}|array{_: 'secureValueTypePhone'}|array{_: 'secureValueTypeEmail'}>}|array{_: 'messageActionContactSignUp'}|array{_: 'messageActionGeoProximityReached', from_id: array|int|string, to_id: array|int|string, distance: int}|array{_: 'messageActionGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, duration: int}|array{_: 'messageActionInviteToGroupCall', call: array{_: 'inputGroupCall', id: int, access_hash: int}, users: list<int>}|array{_: 'messageActionSetMessagesTTL', period: int, auto_setting_from: int}|array{_: 'messageActionGroupCallScheduled', call: array{_: 'inputGroupCall', id: int, access_hash: int}, schedule_date: int}|array{_: 'messageActionSetChatTheme', emoticon: string}|array{_: 'messageActionChatJoinedByRequest'}|array{_: 'messageActionWebViewDataSentMe', text: string, data: string}|array{_: 'messageActionWebViewDataSent', text: string}|array{_: 'messageActionGiftPremium', currency: string, amount: int, months: int}|array{_: 'messageActionTopicCreate', title: string, icon_color: int, icon_emoji_id: int}|array{_: 'messageActionTopicEdit', title: string, icon_emoji_id: int, closed?: bool, hidden?: bool}|array{_: 'messageActionSuggestProfilePhoto', photo: array{_: 'photoEmpty', id: int}|array{_: 'photo', has_stickers: bool, id: int, access_hash: int, file_reference: string, date: int, sizes: list<array{_: 'photoSizeEmpty', type: string}|array{_: 'photoSize', type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', type: string, w: int, h: int, bytes: string}|array{_: 'photoStrippedSize', type: string, bytes: string}|array{_: 'photoSizeProgressive', type: string, w: int, h: int, sizes: list<int>}|array{_: 'photoPathSize', type: string, bytes: string}|array{_: 'photoSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, size: int}|array{_: 'photoCachedSize', location: array{_: 'fileLocationUnavailable', volume_id: array, local_id: array, secret: array}|array{_: 'fileLocation', dc_id: array, volume_id: array, local_id: array, secret: array}, type: string, w: int, h: int, bytes: string}>, video_sizes: list<array{_: 'videoSize', type: string, w: int, h: int, size: int, video_start_ts?: float}|array{_: 'videoSizeEmojiMarkup', emoji_id: int, background_colors: list<int>}|array{_: 'videoSizeStickerMarkup', stickerset: array{_: 'inputStickerSetEmpty'}|array{_: 'inputStickerSetID', id: array, access_hash: array}|array{_: 'inputStickerSetShortName', short_name: array}|array{_: 'inputStickerSetAnimatedEmoji'}|array{_: 'inputStickerSetDice', emoticon: array}|array{_: 'inputStickerSetAnimatedEmojiAnimations'}|array{_: 'inputStickerSetPremiumGifts'}|array{_: 'inputStickerSetEmojiGenericAnimations'}|array{_: 'inputStickerSetEmojiDefaultStatuses'}|array{_: 'inputStickerSetEmojiDefaultTopicIcons'}, sticker_id: int, background_colors: list<int>}>, dc_id: int}}|array{_: 'messageActionAttachMenuBotAllowed'}|array{_: 'messageActionRequestedPeer', peer: array|int|string, button_id: int}, out: bool, mentioned: bool, media_unread: bool, silent: bool, post: bool, legacy: bool, id: int, from_id?: array|int|string, reply_to?: array{_: 'messageReplyHeader', reply_to_scheduled: bool, forum_topic: bool, reply_to_msg_id: int, reply_to_peer_id?: array|int|string, reply_to_top_id: int}, date: int, ttl_period: int}>, chats: list<array|int|string>, users: list<array|int|string>, pts: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.ForumTopics.html
     */
    public function getForumTopicsByID(array|int|string $channel, array $topics = []): array;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $topic_id 
     * @param string $title 
     * @param int $icon_emoji_id 
     * @param bool $closed 
     * @param bool $hidden 
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function editForumTopic(array|int|string $channel, int $topic_id = 0, string $title = '', int $icon_emoji_id = 0, bool $closed = false, bool $hidden = false): array;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $pinned 
     * @param int $topic_id 
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function updatePinnedForumTopic(array|int|string $channel, bool $pinned, int $topic_id = 0): array;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $top_msg_id 
     * @return array{_: 'messages.affectedHistory', pts: int, pts_count: int, offset: int} @see https://docs.madelineproto.xyz/API_docs/types/messages.AffectedHistory.html
     */
    public function deleteTopicHistory(array|int|string $channel, int $top_msg_id = 0): array;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $force 
     * @param list<int>|array<never, never> $order 
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function reorderPinnedForumTopics(array|int|string $channel, bool $force = false, array $order = []): array;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $enabled 
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleAntiSpam(array|int|string $channel, bool $enabled): array;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param int $msg_id 
     * @return bool 
     */
    public function reportAntiSpamFalsePositive(array|int|string $channel, int $msg_id = 0): bool;

    /**
     * 
     *
     * @param array|int|string $channel @see https://docs.madelineproto.xyz/API_docs/types/InputChannel.html
     * @param bool $enabled 
     * @return array @see https://docs.madelineproto.xyz/API_docs/types/Updates.html
     */
    public function toggleParticipantsHidden(array|int|string $channel, bool $enabled): array;
}
